/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import java.util.IdentityHashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.PrecomputedCodecCache;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

@Beta
public final class LazyCodecCache<T>
extends CodecCache<T> {
    private final Map<SchemaNode, T> complexCodecs = new IdentityHashMap<SchemaNode, T>();
    private final Map<TypeDefinition<?>, T> simpleCodecs = new IdentityHashMap();

    @Override
    <S extends SchemaNode & TypeAware> T getComplex(S schema, T codec) {
        return (T)this.complexCodecs.computeIfAbsent(schema, any -> codec);
    }

    @Override
    <S extends SchemaNode & TypeAware> T lookupComplex(S schema) {
        return this.complexCodecs.get(schema);
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return this.simpleCodecs.get(type);
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        return (T)this.simpleCodecs.computeIfAbsent(type, any -> codec);
    }

    public PrecomputedCodecCache<T> toPrecomputed() {
        return new PrecomputedCodecCache<T>(this.simpleCodecs, this.complexCodecs);
    }
}

