/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

@Beta
public final class SharedCodecCache<T>
extends CodecCache<T> {
    private final Cache<TypeDefinition<?>, T> simpleCodecs = CacheBuilder.newBuilder().weakKeys().softValues().build();
    private final Cache<SchemaNode, T> complexCodecs = CacheBuilder.newBuilder().weakKeys().softValues().build();

    @Override
    public <S extends SchemaNode & TypeAware> T lookupComplex(S schema) {
        return (T)this.complexCodecs.getIfPresent(schema);
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return (T)this.simpleCodecs.getIfPresent(type);
    }

    @Override
    <S extends SchemaNode & TypeAware> T getComplex(S schema, T codec) {
        try {
            return (T)this.complexCodecs.get(schema, () -> codec);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new IllegalStateException(e);
        }
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        try {
            return (T)this.simpleCodecs.get(type, () -> codec);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new IllegalStateException(e);
        }
    }
}

