/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodesBuilder
implements Builder<Nodes> {
    private Map<NodeKey, Node> _node;
    Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();

    public NodesBuilder() {
    }

    public NodesBuilder(Nodes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(aug);
        }
        this._node = base.getNode();
    }

    public Map<NodeKey, Node> getNode() {
        return this._node;
    }

    public <E$$ extends Augmentation<Nodes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodesBuilder setNode(Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodesBuilder setNode(List<Node> values) {
        return this.setNode(CodeHelpers.compatMap(values));
    }

    public NodesBuilder addAugmentation(Augmentation<Nodes> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public NodesBuilder addAugmentation(Class<? extends Augmentation<Nodes>> augmentationType, Augmentation<Nodes> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public NodesBuilder removeAugmentation(Class<? extends Augmentation<Nodes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private NodesBuilder doAddAugmentation(Class<? extends Augmentation<Nodes>> augmentationType, Augmentation<Nodes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Nodes build() {
        return new NodesImpl(this);
    }

    private static final class NodesImpl
    extends AbstractAugmentable<Nodes>
    implements Nodes {
        private final Map<NodeKey, Node> _node;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodesImpl(NodesBuilder base) {
            super(base.augmentation);
            this._node = CodeHelpers.emptyToNull(base.getNode());
        }

        @Override
        public Map<NodeKey, Node> getNode() {
            return this._node;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Nodes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Nodes other = (Nodes)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodesImpl otherImpl = (NodesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Nodes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_node", this._node);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

