/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMActionNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionProviderServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMActionServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTable;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouterServices;
import org.opendaylight.mdsal.dom.broker.DOMRpcRoutingTable;
import org.opendaylight.mdsal.dom.broker.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.spi.AbstractDOMRpcImplementationRegistration;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DOMRpcRouter
extends AbstractRegistration
implements DOMRpcRouterServices,
EffectiveModelContextListener {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("DOMRpcRouter-listener-%s").setDaemon(true).build();
    private final ExecutorService listenerNotifier = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final @NonNull DOMActionProviderService actionProviderService = new ActionProviderServiceFacade();
    private final @NonNull DOMActionService actionService = new ActionServiceFacade();
    private final @NonNull DOMRpcProviderService rpcProviderService = new RpcProviderServiceFacade();
    private final @NonNull DOMRpcService rpcService = new RpcServiceFacade();
    private @GuardedBy(value={"this"}) Collection<Registration<?>> listeners = Collections.emptyList();
    private @GuardedBy(value={"this"}) Collection<ActionRegistration<?>> actionListeners = Collections.emptyList();
    private volatile DOMRpcRoutingTable routingTable = DOMRpcRoutingTable.EMPTY;
    private volatile DOMActionRoutingTable actionRoutingTable = DOMActionRoutingTable.EMPTY;
    private ListenerRegistration<?> listenerRegistration;

    @Inject
    public static DOMRpcRouter newInstance(DOMSchemaService schemaService) {
        DOMRpcRouter rpcRouter = new DOMRpcRouter();
        rpcRouter.listenerRegistration = schemaService.registerSchemaContextListener((EffectiveModelContextListener)rpcRouter);
        return rpcRouter;
    }

    @Override
    public DOMActionService getActionService() {
        return this.actionService;
    }

    @Override
    public DOMActionProviderService getActionProviderService() {
        return this.actionProviderService;
    }

    @Override
    public DOMRpcService getRpcService() {
        return this.rpcService;
    }

    @Override
    public DOMRpcProviderService getRpcProviderService() {
        return this.rpcProviderService;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void removeRpcImplementation(DOMRpcImplementation implementation, Set<DOMRpcIdentifier> rpcs) {
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.remove(implementation, rpcs);
        this.listenerNotifier.execute(() -> this.notifyRemoved(newTable, implementation));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void removeActionImplementation(DOMActionImplementation implementation, Set<DOMActionInstance> actions) {
        DOMActionRoutingTable newTable;
        DOMActionRoutingTable oldTable = this.actionRoutingTable;
        this.actionRoutingTable = newTable = (DOMActionRoutingTable)oldTable.remove(implementation, actions);
        this.listenerNotifier.execute(() -> this.notifyActionChanged(newTable, implementation));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void removeListener(ListenerRegistration<? extends DOMRpcAvailabilityListener> reg) {
        this.listeners = ImmutableList.copyOf((Collection)Collections2.filter(this.listeners, input -> !reg.equals((Object)input)));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void removeActionListener(ListenerRegistration<? extends DOMActionAvailabilityExtension.AvailabilityListener> reg) {
        this.actionListeners = ImmutableList.copyOf((Collection)Collections2.filter(this.actionListeners, input -> !reg.equals((Object)input)));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void notifyAdded(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
        for (Registration<?> l : this.listeners) {
            l.addRpc(newTable, impl);
        }
    }

    private synchronized void notifyRemoved(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
        for (Registration<?> l : this.listeners) {
            l.removeRpc(newTable, impl);
        }
    }

    private synchronized void notifyActionChanged(DOMActionRoutingTable newTable, DOMActionImplementation impl) {
        for (ActionRegistration<?> l : this.actionListeners) {
            l.actionChanged(newTable, impl);
        }
    }

    public synchronized void onModelContextUpdated(EffectiveModelContext newModelContext) {
        DOMActionRoutingTable newActionTable;
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.setSchemaContext(newModelContext);
        DOMActionRoutingTable oldActionTable = this.actionRoutingTable;
        this.actionRoutingTable = newActionTable = (DOMActionRoutingTable)oldActionTable.setSchemaContext(newModelContext);
    }

    protected void removeRegistration() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
            this.listenerRegistration = null;
        }
        this.listenerNotifier.shutdown();
    }

    @VisibleForTesting
    synchronized Collection<?> listeners() {
        return this.listeners;
    }

    @VisibleForTesting
    DOMRpcRoutingTable routingTable() {
        return this.routingTable;
    }

    static final class OperationInvocation {
        private static final Logger LOG = LoggerFactory.getLogger(OperationInvocation.class);

        OperationInvocation() {
        }

        static ListenableFuture<? extends DOMActionResult> invoke(DOMActionRoutingTableEntry entry, SchemaPath type, DOMDataTreeIdentifier path, ContainerNode input) {
            return ((DOMActionImplementation)entry.getImplementations(path).get(0)).invokeAction(type, path, input);
        }

        static ListenableFuture<? extends DOMRpcResult> invoke(AbstractDOMRpcRoutingTableEntry entry, NormalizedNode<?, ?> input) {
            if (entry instanceof UnknownDOMRpcRoutingTableEntry) {
                return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("SchemaPath %s is not resolved to an RPC", new Object[]{entry.getType()}));
            }
            if (entry instanceof RoutedDOMRpcRoutingTableEntry) {
                return OperationInvocation.invokeRoutedRpc((RoutedDOMRpcRoutingTableEntry)entry, input);
            }
            if (entry instanceof GlobalDOMRpcRoutingTableEntry) {
                return OperationInvocation.invokeGlobalRpc((GlobalDOMRpcRoutingTableEntry)entry, input);
            }
            return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("Unsupported RPC entry.", new Object[0]));
        }

        private static ListenableFuture<? extends DOMRpcResult> invokeRoutedRpc(RoutedDOMRpcRoutingTableEntry entry, NormalizedNode<?, ?> input) {
            List impls;
            Optional maybeKey = NormalizedNodes.findNode(input, (YangInstanceIdentifier)entry.getRpcId().getContextReference());
            if (maybeKey.isPresent()) {
                NormalizedNode key = (NormalizedNode)maybeKey.get();
                Object value = key.getValue();
                if (value instanceof YangInstanceIdentifier) {
                    YangInstanceIdentifier iid = (YangInstanceIdentifier)value;
                    List specificImpls = entry.getImplementations(iid);
                    if (specificImpls != null) {
                        return ((DOMRpcImplementation)specificImpls.get(0)).invokeRpc(DOMRpcIdentifier.create((SchemaPath)entry.getType(), (YangInstanceIdentifier)iid), input);
                    }
                    LOG.debug("No implementation for context {} found will now look for wildcard id", (Object)iid);
                    List mayBeRemoteImpls = entry.getImplementations(YangInstanceIdentifier.empty());
                    if (mayBeRemoteImpls != null) {
                        return ((DOMRpcImplementation)mayBeRemoteImpls.get(0)).invokeRpc(DOMRpcIdentifier.create((SchemaPath)entry.getType(), (YangInstanceIdentifier)iid), input);
                    }
                } else {
                    LOG.warn("Ignoring wrong context value {}", value);
                }
            }
            if ((impls = entry.getImplementations(null)) != null) {
                return ((DOMRpcImplementation)impls.get(0)).invokeRpc(entry.getRpcId(), input);
            }
            return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{entry.getType()}));
        }

        private static ListenableFuture<? extends DOMRpcResult> invokeGlobalRpc(GlobalDOMRpcRoutingTableEntry entry, NormalizedNode<?, ?> input) {
            return ((DOMRpcImplementation)entry.getImplementations(YangInstanceIdentifier.empty()).get(0)).invokeRpc(entry.getRpcId(), input);
        }
    }

    private final class RpcProviderServiceFacade
    implements DOMRpcProviderService {
        private RpcProviderServiceFacade() {
        }

        public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(T implementation, DOMRpcIdentifier ... rpcs) {
            return this.registerRpcImplementation(implementation, (Set<DOMRpcIdentifier>)ImmutableSet.copyOf((Object[])rpcs));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(T implementation, final Set<DOMRpcIdentifier> rpcs) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                DOMRpcRoutingTable newTable;
                DOMRpcRoutingTable oldTable = DOMRpcRouter.this.routingTable;
                DOMRpcRouter.this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.add(implementation, rpcs);
                DOMRpcRouter.this.listenerNotifier.execute(() -> DOMRpcRouter.this.notifyAdded(newTable, implementation));
            }
            return new AbstractDOMRpcImplementationRegistration<T>(implementation){

                protected void removeRegistration() {
                    DOMRpcRouter.this.removeRpcImplementation((DOMRpcImplementation)this.getInstance(), rpcs);
                }
            };
        }
    }

    private final class RpcServiceFacade
    implements DOMRpcService {
        private RpcServiceFacade() {
        }

        public ListenableFuture<? extends DOMRpcResult> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
            AbstractDOMRpcRoutingTableEntry entry = (AbstractDOMRpcRoutingTableEntry)DOMRpcRouter.this.routingTable.getEntry(type);
            if (entry == null) {
                return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{type}));
            }
            return OperationInvocation.invoke(entry, Objects.requireNonNull(input));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(T listener) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                Registration<T> ret = new Registration<T>(DOMRpcRouter.this, listener, DOMRpcRouter.this.routingTable.getOperations(listener));
                ImmutableList.Builder b = ImmutableList.builder();
                b.addAll(DOMRpcRouter.this.listeners);
                b.add(ret);
                DOMRpcRouter.this.listeners = b.build();
                DOMRpcRouter.this.listenerNotifier.execute(ret::initialTable);
                return ret;
            }
        }
    }

    @NonNullByDefault
    private final class ActionProviderServiceFacade
    implements DOMActionProviderService {
        private ActionProviderServiceFacade() {
        }

        public ClassToInstanceMap<DOMActionProviderServiceExtension> getExtensions() {
            return ImmutableClassToInstanceMap.of();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends DOMActionImplementation> ObjectRegistration<T> registerActionImplementation(T implementation, final Set<DOMActionInstance> instances) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                DOMActionRoutingTable newTable;
                DOMActionRoutingTable oldTable = DOMRpcRouter.this.actionRoutingTable;
                DOMRpcRouter.this.actionRoutingTable = newTable = (DOMActionRoutingTable)oldTable.add(implementation, instances);
                DOMRpcRouter.this.listenerNotifier.execute(() -> DOMRpcRouter.this.notifyActionChanged(newTable, implementation));
            }
            return new AbstractObjectRegistration<T>(implementation){

                protected void removeRegistration() {
                    DOMRpcRouter.this.removeActionImplementation((DOMActionImplementation)this.getInstance(), instances);
                }
            };
        }
    }

    @NonNullByDefault
    private final class ActionServiceFacade
    implements DOMActionService {
        private final ClassToInstanceMap<DOMActionServiceExtension> extensions;

        private ActionServiceFacade() {
            this.extensions = ImmutableClassToInstanceMap.of(DOMActionAvailabilityExtension.class, (Object)new ActionAvailabilityFacade());
        }

        public ClassToInstanceMap<DOMActionServiceExtension> getExtensions() {
            return this.extensions;
        }

        public ListenableFuture<? extends DOMActionResult> invokeAction(SchemaPath type, DOMDataTreeIdentifier path, ContainerNode input) {
            DOMActionRoutingTableEntry entry = (DOMActionRoutingTableEntry)DOMRpcRouter.this.actionRoutingTable.getEntry(type);
            if (entry == null) {
                return Futures.immediateFailedFuture((Throwable)new DOMActionNotAvailableException("No implementation of Action %s available", new Object[]{type}));
            }
            return OperationInvocation.invoke(entry, type, path, Objects.requireNonNull(input));
        }
    }

    @NonNullByDefault
    private final class ActionAvailabilityFacade
    implements DOMActionAvailabilityExtension {
        private ActionAvailabilityFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends DOMActionAvailabilityExtension.AvailabilityListener> ListenerRegistration<T> registerAvailabilityListener(T listener) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                ActionRegistration<T> ret = new ActionRegistration<T>(DOMRpcRouter.this, listener, DOMRpcRouter.this.actionRoutingTable.getOperations(listener));
                ImmutableList.Builder b = ImmutableList.builder();
                b.addAll(DOMRpcRouter.this.actionListeners);
                b.add(ret);
                DOMRpcRouter.this.actionListeners = b.build();
                DOMRpcRouter.this.listenerNotifier.execute(ret::initialTable);
                return ret;
            }
        }
    }

    private static final class ActionRegistration<T extends DOMActionAvailabilityExtension.AvailabilityListener>
    extends AbstractListenerRegistration<T> {
        private Map<SchemaPath, Set<DOMDataTreeIdentifier>> prevActions;
        private DOMRpcRouter router;

        ActionRegistration(DOMRpcRouter router, T listener, Map<SchemaPath, Set<DOMDataTreeIdentifier>> actions) {
            super(listener);
            this.router = Objects.requireNonNull(router);
            this.prevActions = Objects.requireNonNull(actions);
        }

        protected void removeRegistration() {
            this.router.removeActionListener((ListenerRegistration<? extends DOMActionAvailabilityExtension.AvailabilityListener>)this);
            this.router = null;
        }

        void initialTable() {
            ArrayList added = new ArrayList();
            for (Map.Entry<SchemaPath, Set<DOMDataTreeIdentifier>> e : this.prevActions.entrySet()) {
                added.addAll(Collections2.transform((Collection)e.getValue(), i -> DOMActionInstance.of((SchemaPath)((SchemaPath)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            if (!added.isEmpty()) {
                ((DOMActionAvailabilityExtension.AvailabilityListener)this.getInstance()).onActionsChanged((Set)ImmutableSet.of(), (Set)ImmutableSet.copyOf(added));
            }
        }

        void actionChanged(DOMActionRoutingTable newTable, DOMActionImplementation impl) {
            DOMActionAvailabilityExtension.AvailabilityListener l = (DOMActionAvailabilityExtension.AvailabilityListener)this.getInstance();
            if (!l.acceptsImplementation(impl)) {
                return;
            }
            Map actions = (Map)Verify.verifyNotNull(newTable.getOperations(l));
            MapDifference diff = Maps.difference(this.prevActions, (Map)actions);
            HashSet<DOMActionInstance> removed = new HashSet<DOMActionInstance>();
            HashSet<DOMActionInstance> added = new HashSet<DOMActionInstance>();
            for (Map.Entry e : diff.entriesOnlyOnLeft().entrySet()) {
                removed.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMActionInstance.of((SchemaPath)((SchemaPath)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            for (Map.Entry e : diff.entriesOnlyOnRight().entrySet()) {
                added.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMActionInstance.of((SchemaPath)((SchemaPath)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (DOMDataTreeIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()))) {
                    removed.add(DOMActionInstance.of((SchemaPath)((SchemaPath)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i2}));
                }
                for (DOMDataTreeIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()))) {
                    added.add(DOMActionInstance.of((SchemaPath)((SchemaPath)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i2}));
                }
            }
            this.prevActions = actions;
            if (!removed.isEmpty() || !added.isEmpty()) {
                l.onActionsChanged(removed, added);
            }
        }
    }

    private static final class Registration<T extends DOMRpcAvailabilityListener>
    extends AbstractListenerRegistration<T> {
        private Map<SchemaPath, Set<YangInstanceIdentifier>> prevRpcs;
        private DOMRpcRouter router;

        Registration(DOMRpcRouter router, T listener, Map<SchemaPath, Set<YangInstanceIdentifier>> rpcs) {
            super(listener);
            this.router = Objects.requireNonNull(router);
            this.prevRpcs = Objects.requireNonNull(rpcs);
        }

        protected void removeRegistration() {
            this.router.removeListener((ListenerRegistration<? extends DOMRpcAvailabilityListener>)this);
            this.router = null;
        }

        void initialTable() {
            ArrayList added = new ArrayList();
            for (Map.Entry<SchemaPath, Set<YangInstanceIdentifier>> e : this.prevRpcs.entrySet()) {
                added.addAll(Collections2.transform((Collection)e.getValue(), i -> DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)i)));
            }
            if (!added.isEmpty()) {
                ((DOMRpcAvailabilityListener)this.getInstance()).onRpcAvailable(added);
            }
        }

        void addRpc(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
            DOMRpcAvailabilityListener l = (DOMRpcAvailabilityListener)this.getInstance();
            if (!l.acceptsImplementation(impl)) {
                return;
            }
            Map rpcs = (Map)Verify.verifyNotNull(newTable.getOperations(l));
            MapDifference diff = Maps.difference(this.prevRpcs, (Map)rpcs);
            ArrayList<DOMRpcIdentifier> added = new ArrayList<DOMRpcIdentifier>();
            for (Map.Entry e : diff.entriesOnlyOnRight().entrySet()) {
                added.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)i)));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (YangInstanceIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()))) {
                    added.add(DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)i2));
                }
            }
            this.prevRpcs = rpcs;
            if (!added.isEmpty()) {
                l.onRpcAvailable(added);
            }
        }

        void removeRpc(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
            DOMRpcAvailabilityListener l = (DOMRpcAvailabilityListener)this.getInstance();
            if (!l.acceptsImplementation(impl)) {
                return;
            }
            Map rpcs = (Map)Verify.verifyNotNull(newTable.getOperations(l));
            MapDifference diff = Maps.difference(this.prevRpcs, (Map)rpcs);
            ArrayList<DOMRpcIdentifier> removed = new ArrayList<DOMRpcIdentifier>();
            for (Map.Entry e : diff.entriesOnlyOnLeft().entrySet()) {
                removed.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)i)));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (YangInstanceIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()))) {
                    removed.add(DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)i2));
                }
            }
            this.prevRpcs = rpcs;
            if (!removed.isEmpty()) {
                l.onRpcUnavailable(removed);
            }
        }
    }
}

