/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouter;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.opendaylight.mdsal.dom.notification"}, service={DOMNotificationService.class, DOMNotificationPublishService.class, DOMNotificationSubscriptionListenerRegistry.class})
@Designate(ocd=Config.class)
public final class OSGiDOMNotificationRouter
implements DOMNotificationService,
DOMNotificationPublishService,
DOMNotificationSubscriptionListenerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMNotificationRouter.class);
    private DOMNotificationRouter router;

    @Activate
    void activate(Config config) {
        this.router = DOMNotificationRouter.create(config.queueDepth(), config.spinTime(), config.parkTime(), TimeUnit.MILLISECONDS);
        LOG.info("DOM Notification Router started");
    }

    @Deactivate
    void deactivate() {
        this.router.close();
        this.router = null;
        LOG.info("DOM Notification Router stopped");
    }

    public <L extends DOMNotificationSubscriptionListener> ListenerRegistration<L> registerSubscriptionListener(L listener) {
        return this.router.registerSubscriptionListener(listener);
    }

    public ListenableFuture<? extends Object> putNotification(DOMNotification notification) throws InterruptedException {
        return this.router.putNotification(notification);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification) {
        return this.router.offerNotification(notification);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
        return this.router.offerNotification(notification, timeout, unit);
    }

    public <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, Collection<SchemaPath> types) {
        return this.router.registerNotificationListener(listener, types);
    }

    public <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, SchemaPath ... types) {
        return this.router.registerNotificationListener(listener, types);
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="notification-queue-depth")
        public int queueDepth() default 65536;

        @AttributeDefinition(name="notification-queue-spin")
        public long spinTime() default 0L;

        @AttributeDefinition(name="notification-queue-park")
        public long parkTime() default 0L;
    }
}

