/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.clustering.it.provider.impl.AbstractTransactionHandler;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdIntsListener
implements ClusteredDOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(IdIntsListener.class);
    private static final long SECOND_AS_NANO = 1000000000L;
    private volatile NormalizedNode<?, ?> localCopy;
    private final AtomicLong lastNotifTimestamp = new AtomicLong(0L);
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        Preconditions.checkState((changes.size() == 1 ? 1 : 0) != 0);
        this.lastNotifTimestamp.set(System.nanoTime());
        LOG.debug("Received data tree changed");
        changes.forEach(change -> {
            if (change.getRootNode().getDataAfter().isPresent()) {
                LOG.trace("Received change, data before: {}, data after: {}", change.getRootNode().getDataBefore().isPresent() ? change.getRootNode().getDataBefore().get() : "", change.getRootNode().getDataAfter().get());
                this.localCopy = (NormalizedNode)change.getRootNode().getDataAfter().get();
            } else {
                LOG.warn("getDataAfter() is missing from notification. change: {}", change);
            }
        });
    }

    public boolean hasTriggered() {
        return this.localCopy != null;
    }

    public boolean checkEqual(NormalizedNode<?, ?> expected) {
        return this.localCopy.equals(expected);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public String diffWithLocalCopy(NormalizedNode<?, ?> expected) {
        return IdIntsListener.diffNodes((MapNode)expected, (MapNode)this.localCopy);
    }

    public Future<Void> tryFinishProcessing() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        SettableFuture settableFuture = SettableFuture.create();
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(new CheckFinishedTask((SettableFuture<Void>)settableFuture), 0L, 1L, TimeUnit.SECONDS);
        return settableFuture;
    }

    public static String diffNodes(MapNode expected, MapNode actual) {
        StringBuilder builder = new StringBuilder("MapNodes diff:");
        YangInstanceIdentifier.NodeIdentifier itemNodeId = new YangInstanceIdentifier.NodeIdentifier(AbstractTransactionHandler.ITEM);
        HashMap expIdIntMap = new HashMap();
        expected.getValue().forEach(node -> expIdIntMap.put(node.getIdentifier(), node));
        actual.getValue().forEach(actIdInt -> {
            MapEntryNode expIdInt = (MapEntryNode)expIdIntMap.remove(actIdInt.getIdentifier());
            if (expIdInt == null) {
                builder.append('\n').append("  Unexpected id-int entry for ").append(actIdInt.getIdentifier());
                return;
            }
            HashMap expItemMap = new HashMap();
            ((MapNode)expIdInt.getChild((YangInstanceIdentifier.PathArgument)itemNodeId).get()).getValue().forEach(node -> expItemMap.put(node.getIdentifier(), node));
            ((MapNode)actIdInt.getChild((YangInstanceIdentifier.PathArgument)itemNodeId).get()).getValue().forEach(actItem -> {
                MapEntryNode expItem = (MapEntryNode)expItemMap.remove(actItem.getIdentifier());
                if (expItem == null) {
                    builder.append('\n').append("  Unexpected item entry ").append(actItem.getIdentifier()).append(" for id-int entry ").append(actIdInt.getIdentifier());
                }
            });
            expItemMap.values().forEach(node -> builder.append('\n').append("  Actual is missing item entry ").append(node.getIdentifier()).append(" for id-int entry ").append(actIdInt.getIdentifier()));
        });
        expIdIntMap.values().forEach(node -> builder.append('\n').append("  Actual is missing id-int entry for ").append(node.getIdentifier()));
        return builder.toString();
    }

    private class CheckFinishedTask
    implements Runnable {
        private final SettableFuture<Void> future;

        CheckFinishedTask(SettableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (System.nanoTime() - IdIntsListener.this.lastNotifTimestamp.get() > 4000000000L) {
                IdIntsListener.this.scheduledFuture.cancel(false);
                this.future.set(null);
                IdIntsListener.this.executorService.shutdown();
            }
        }
    }
}

