/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.Type;

final class ConstantImpl
implements Constant {
    private final Type definingType;
    private final Type type;
    private final String name;
    private final Object value;

    ConstantImpl(Type definingType, Type type, String name, Object value) {
        this.definingType = definingType;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Type getDefiningType() {
        return this.definingType;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toFormattedString() {
        return this.type + " " + this.name + " " + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantImpl other = (ConstantImpl)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Constant [type=");
        builder.append(this.type);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", value=");
        builder.append(this.value);
        if (this.definingType != null) {
            builder.append(", definingType=");
            builder.append(this.definingType.getPackageName());
            builder.append(".");
            builder.append(this.definingType.getName());
        } else {
            builder.append(", definingType= null");
        }
        builder.append("]");
        return builder.toString();
    }
}

