/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.namespace;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ChildSchemaNodeNamespace<D extends DeclaredStatement<QName>, E extends EffectiveStatement<QName, D>>
extends NamespaceBehaviour<QName, StmtContext<?, D, E>, ChildSchemaNodeNamespace<D, E>>
implements StatementNamespace<QName, D, E> {
    public ChildSchemaNodeNamespace() {
        super(ChildSchemaNodeNamespace.class);
    }

    public StmtContext<?, D, E> get(QName key) {
        return null;
    }

    public StmtContext<?, D, E> getFrom(NamespaceBehaviour.NamespaceStorageNode storage, QName key) {
        return (StmtContext)ChildSchemaNodeNamespace.globalOrStatementSpecific(storage).getFromLocalStorage((Class)this.getIdentifier(), (Object)key);
    }

    public Map<QName, StmtContext<?, D, E>> getAllFrom(NamespaceBehaviour.NamespaceStorageNode storage) {
        return null;
    }

    public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, QName key, StmtContext<?, D, E> value) {
        StmtContext prev = (StmtContext)ChildSchemaNodeNamespace.globalOrStatementSpecific(storage).putToLocalStorageIfAbsent(ChildSchemaNodeNamespace.class, (Object)key, value);
        if (prev != null) {
            throw new SourceException(value.getStatementSourceReference(), "Error in module '%s': cannot add '%s'. Node name collision: '%s' already declared at %s", new Object[]{value.getRoot().getStatementArgument(), key, prev.getStatementArgument(), prev.getStatementSourceReference()});
        }
    }

    public static Optional<StmtContext<?, ?, ?>> findNode(StmtContext<?, ?, ?> root, SchemaNodeIdentifier identifier) {
        Iterator iterator = identifier.getNodeIdentifiers().iterator();
        if (!iterator.hasNext()) {
            return Optional.of(root);
        }
        QName nextPath = (QName)iterator.next();
        StmtContext current = (StmtContext)root.getFromNamespace(ChildSchemaNodeNamespace.class, (Object)nextPath);
        if (current == null) {
            return Optional.ofNullable(ChildSchemaNodeNamespace.tryToFindUnknownStatement(nextPath.getLocalName(), root));
        }
        while (current != null && iterator.hasNext()) {
            nextPath = (QName)iterator.next();
            StmtContext nextNodeCtx = (StmtContext)current.getFromNamespace(ChildSchemaNodeNamespace.class, (Object)nextPath);
            if (nextNodeCtx == null) {
                return Optional.ofNullable(ChildSchemaNodeNamespace.tryToFindUnknownStatement(nextPath.getLocalName(), current));
            }
            current = nextNodeCtx;
        }
        return Optional.ofNullable(current);
    }

    private static StmtContext<?, ?, ?> tryToFindUnknownStatement(String localName, StmtContext<?, ?, ?> current) {
        Collection unknownSubstatements = StmtContextUtils.findAllSubstatements(current, UnknownStatement.class);
        for (StmtContext unknownSubstatement : unknownSubstatements) {
            if (!localName.equals(unknownSubstatement.rawStatementArgument())) continue;
            return unknownSubstatement;
        }
        return null;
    }

    private static NamespaceBehaviour.NamespaceStorageNode globalOrStatementSpecific(NamespaceBehaviour.NamespaceStorageNode storage) {
        NamespaceBehaviour.NamespaceStorageNode current = storage;
        while (!ChildSchemaNodeNamespace.isLocalOrGlobal(current.getStorageNodeType())) {
            current = current.getParentNamespaceStorage();
        }
        return current;
    }

    private static boolean isLocalOrGlobal(NamespaceBehaviour.StorageNodeType type) {
        return type == NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL || type == NamespaceBehaviour.StorageNodeType.GLOBAL;
    }
}

