/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class ArgumentContextUtils {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();

    private ArgumentContextUtils() {
    }

    static @NonNull ArgumentContextUtils forVersion(YangVersion version) {
        switch (version) {
            case VERSION_1: {
                return RFC6020.INSTANCE;
            }
            case VERSION_1_1: {
                return RFC7950.INSTANCE;
            }
        }
        throw new IllegalStateException("Unhandled version " + version);
    }

    static @NonNull ArgumentContextUtils rfc6020() {
        return RFC6020.INSTANCE;
    }

    final @NonNull String stringFromStringContext(YangStatementParser.ArgumentContext context, StatementSourceReference ref) {
        ParseTree firstChild = context.getChild(0);
        Verify.verify((boolean)(firstChild instanceof TerminalNode), (String)"Unexpected shape of %s", (Object)context);
        TerminalNode firstNode = (TerminalNode)firstChild;
        int firstType = firstNode.getSymbol().getType();
        switch (firstType) {
            case 5: {
                return firstNode.getText();
            }
            case 10: {
                return this.concatStrings(context, ref);
            }
        }
        throw new VerifyException("Unexpected first symbol in " + context);
    }

    private String concatStrings(YangStatementParser.ArgumentContext context, StatementSourceReference ref) {
        StringBuilder sb = new StringBuilder();
        block5: for (ParseTree child : context.children) {
            Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected fragment component %s", (Object)child);
            TerminalNode childNode = (TerminalNode)child;
            switch (childNode.getSymbol().getType()) {
                case 4: {
                    continue block5;
                }
                case 7: {
                    continue block5;
                }
                case 10: {
                    this.appendString(sb, childNode, ref);
                    continue block5;
                }
            }
            throw new VerifyException("Unexpected symbol in " + childNode);
        }
        return sb.toString();
    }

    private void appendString(StringBuilder sb, TerminalNode stringNode, StatementSourceReference ref) {
        String str = stringNode.getText();
        char firstChar = str.charAt(0);
        char lastChar = str.charAt(str.length() - 1);
        if (firstChar == '\"' && lastChar == '\"') {
            sb.append(this.normalizeDoubleQuoted(str.substring(1, str.length() - 1), stringNode.getSymbol().getCharPositionInLine(), ref));
        } else if (firstChar == '\'' && lastChar == '\'') {
            sb.append(str, 1, str.length() - 1);
        } else {
            this.checkUnquoted(str, ref);
            sb.append(str);
        }
    }

    private String normalizeDoubleQuoted(String str, int dquot, StatementSourceReference ref) {
        String stripped = ArgumentContextUtils.trimWhitespace(str, dquot);
        int backslash = stripped.indexOf(92);
        return backslash == -1 ? stripped : this.unescape(ref, stripped, backslash);
    }

    abstract void checkDoubleQuoted(String var1, StatementSourceReference var2, int var3);

    abstract void checkUnquoted(String var1, StatementSourceReference var2);

    private String unescape(StatementSourceReference ref, String str, int backslash) {
        this.checkDoubleQuoted(str, ref, backslash);
        StringBuilder sb = new StringBuilder(str.length());
        ArgumentContextUtils.unescapeBackslash(sb, str, backslash);
        return sb.toString();
    }

    @VisibleForTesting
    static void unescapeBackslash(StringBuilder sb, String str, int backslash) {
        block2: {
            String substring = str;
            int backslashIndex = backslash;
            while (true) {
                int nextIndex = backslashIndex + 1;
                if (backslashIndex == -1 || nextIndex >= substring.length()) break;
                ArgumentContextUtils.replaceBackslash(sb, substring, nextIndex);
                substring = substring.substring(nextIndex + 1);
                if (substring.length() > 0) {
                    backslashIndex = substring.indexOf(92);
                    continue;
                }
                break block2;
                break;
            }
            sb.append(substring);
        }
    }

    private static void replaceBackslash(StringBuilder sb, String str, int nextAfterBackslash) {
        int backslash = nextAfterBackslash - 1;
        sb.append(str, 0, backslash);
        char c = str.charAt(nextAfterBackslash);
        switch (c) {
            case '\"': 
            case '\\': {
                sb.append(c);
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'n': {
                sb.append('\n');
                break;
            }
            default: {
                sb.append(str, backslash, nextAfterBackslash + 1);
            }
        }
    }

    @VisibleForTesting
    static String trimWhitespace(String str, int dquot) {
        int firstBrk = str.indexOf(10);
        if (firstBrk == -1) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(str, 0, ArgumentContextUtils.trimTrailing(str, 0, firstBrk)).append('\n');
        int start = firstBrk + 1;
        int brk = str.indexOf(10, start);
        while (brk != -1) {
            ArgumentContextUtils.trimLeadingAndAppend(sb, dquot, str, start, ArgumentContextUtils.trimTrailing(str, start, brk)).append('\n');
            start = brk + 1;
            brk = str.indexOf(10, start);
        }
        return ArgumentContextUtils.trimLeadingAndAppend(sb, dquot, str, start, length).toString();
    }

    private static StringBuilder trimLeadingAndAppend(StringBuilder sb, int dquot, String str, int start, int end) {
        int offset = start;
        int pos = 0;
        while (pos <= dquot) {
            if (offset == end) {
                return sb;
            }
            char ch = str.charAt(offset);
            if (ch == '\t') {
                pos += 8;
            } else {
                if (!WHITESPACE_MATCHER.matches(ch)) break;
                ++pos;
            }
            ++offset;
        }
        while (pos - 1 > dquot) {
            sb.append(' ');
            --pos;
        }
        return sb.append(str, offset, end);
    }

    private static int trimTrailing(String str, int start, int end) {
        int prev;
        int ret = end;
        while (ret > start && WHITESPACE_MATCHER.matches(str.charAt(prev = ret - 1))) {
            ret = prev;
        }
        return ret;
    }

    private static final class RFC7950
    extends ArgumentContextUtils {
        private static final CharMatcher ANYQUOTE_MATCHER = CharMatcher.anyOf((CharSequence)"'\"");
        private static final @NonNull RFC7950 INSTANCE = new RFC7950();

        private RFC7950() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
            if (backslash < str.length() - 1) {
                int index = backslash;
                block3: while (index != -1) {
                    switch (str.charAt(index + 1)) {
                        case '\"': 
                        case '\\': 
                        case 'n': 
                        case 't': {
                            index = str.indexOf(92, index + 2);
                            continue block3;
                        }
                    }
                    throw new SourceException(ref, "YANG 1.1: illegal double quoted string (%s). In double quoted string the backslash must be followed by one of the following character [n,t,\",\\], but was '%s'.", new Object[]{str, Character.valueOf(str.charAt(index + 1))});
                }
            }
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
            SourceException.throwIf((boolean)ANYQUOTE_MATCHER.matchesAnyOf((CharSequence)str), (StatementSourceReference)ref, (String)"YANG 1.1: unquoted string (%s) contains illegal characters", (Object[])new Object[]{str});
        }
    }

    private static final class RFC6020
    extends ArgumentContextUtils {
        private static final @NonNull RFC6020 INSTANCE = new RFC6020();

        private RFC6020() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
        }
    }
}

