/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ArgumentContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.DeclarationInTextSource;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;

class StatementContextVisitor {
    private final QNameToStatementDefinition stmtDef;
    private final ArgumentContextUtils utils;
    private final StatementWriter writer;
    private final PrefixToModule prefixes;
    private final String sourceName;

    StatementContextVisitor(String sourceName, StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes, YangVersion yangVersion) {
        this.writer = Objects.requireNonNull(writer);
        this.stmtDef = Objects.requireNonNull(stmtDef);
        this.utils = ArgumentContextUtils.forVersion(yangVersion);
        this.sourceName = sourceName;
        this.prefixes = prefixes;
    }

    void visit(YangStatementParser.StatementContext context) {
        this.processStatement(0, context);
    }

    QName getValidStatementDefinition(String keywordText, StatementSourceReference ref) {
        int firstColon = keywordText.indexOf(58);
        if (firstColon == -1) {
            StatementDefinition def = this.stmtDef.get(QName.create((QNameModule)YangConstants.RFC6020_YIN_MODULE, (String)keywordText));
            return def != null ? def.getStatementName() : null;
        }
        SourceException.throwIf((firstColon == keywordText.length() - 1 || keywordText.indexOf(58, firstColon + 1) != -1 ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Malformed statement '%s'", (Object[])new Object[]{keywordText});
        if (this.prefixes == null) {
            return null;
        }
        String prefix = keywordText.substring(0, firstColon);
        QNameModule qNameModule = this.prefixes.get(prefix);
        if (qNameModule == null) {
            return null;
        }
        String localName = keywordText.substring(firstColon + 1);
        StatementDefinition foundStmtDef = this.resolveStatement(qNameModule, localName);
        return foundStmtDef != null ? foundStmtDef.getStatementName() : null;
    }

    StatementDefinition resolveStatement(QNameModule module, String localName) {
        return this.stmtDef.get(QName.create((QNameModule)module, (String)localName));
    }

    private boolean processStatement(int myOffset, YangStatementParser.StatementContext ctx) {
        Optional optResumed = this.writer.resumeStatement(myOffset);
        if (optResumed.isPresent()) {
            StatementWriter.ResumedStatement resumed = (StatementWriter.ResumedStatement)optResumed.get();
            return resumed.isFullyDefined() || this.doProcessStatement(ctx, resumed.getSourceReference());
        }
        return this.processNewStatement(myOffset, ctx);
    }

    private boolean processNewStatement(int myOffset, YangStatementParser.StatementContext ctx) {
        Token start;
        DeclarationInTextSource ref;
        String keywordTxt = ((YangStatementParser.KeywordContext)Verify.verifyNotNull((Object)((YangStatementParser.KeywordContext)ctx.getChild(YangStatementParser.KeywordContext.class, 0)))).getText();
        QName def = this.getValidStatementDefinition(keywordTxt, (StatementSourceReference)(ref = DeclarationInTextSource.atPosition((String)this.sourceName, (int)(start = ctx.getStart()).getLine(), (int)start.getCharPositionInLine())));
        if (def == null) {
            return false;
        }
        YangStatementParser.ArgumentContext argumentCtx = (YangStatementParser.ArgumentContext)ctx.getChild(YangStatementParser.ArgumentContext.class, 0);
        String argument = argumentCtx == null ? null : this.utils.stringFromStringContext(argumentCtx, (StatementSourceReference)ref);
        this.writer.startStatement(myOffset, def, argument, (StatementSourceReference)ref);
        return this.doProcessStatement(ctx, (StatementSourceReference)ref);
    }

    private boolean doProcessStatement(YangStatementParser.StatementContext ctx, StatementSourceReference ref) {
        int childOffset = 0;
        boolean fullyDefined = true;
        if (ctx.children != null) {
            for (ParseTree s : ctx.children) {
                if (!(s instanceof YangStatementParser.StatementContext) || this.processStatement(childOffset++, (YangStatementParser.StatementContext)s)) continue;
                fullyDefined = false;
            }
        }
        this.writer.storeStatement(childOffset, fullyDefined);
        this.writer.endStatement(ref);
        return fullyDefined;
    }
}

