/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractDeclaredEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveStatement<A, D> {
    public final StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    public abstract @NonNull D getDeclared();

    public static abstract class DefaultWithDataTree<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
    extends WithDataTree<A, D, E> {
        private final @NonNull ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull ImmutableMap<QName, DataTreeEffectiveStatement<?>> dataTree;
        private final @NonNull D declared;

        protected DefaultWithDataTree(D declared, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
            StatementSourceReference ref = ctx.getStatementSourceReference();
            Map<QName, SchemaTreeEffectiveStatement<?>> schema = DefaultWithDataTree.createSchemaTreeNamespace(ref, substatements);
            this.schemaTree = ImmutableMap.copyOf(schema);
            this.dataTree = DefaultWithDataTree.createDataTreeNamespace(ref, schema.values(), this.schemaTree);
        }

        @Override
        public final D getDeclared() {
            return this.declared;
        }

        @Override
        protected final Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace() {
            return this.schemaTree;
        }

        @Override
        protected final Map<QName, DataTreeEffectiveStatement<?>> dataTreeNamespace() {
            return this.dataTree;
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
        extends DefaultWithDataTree<A, D, E> {
            private final @NonNull Object substatements;

            protected WithSubstatements(D declared, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared, ctx, substatements);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class DefaultWithSchemaTree<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
    extends WithSchemaTree<A, D, E> {
        private final @NonNull ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull D declared;

        protected DefaultWithSchemaTree(D declared, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
            this.schemaTree = ImmutableMap.copyOf(DefaultWithSchemaTree.createSchemaTreeNamespace(ctx.getStatementSourceReference(), substatements));
        }

        @Override
        public final D getDeclared() {
            return this.declared;
        }

        @Override
        protected final Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace() {
            return this.schemaTree;
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
        extends DefaultWithSchemaTree<A, D, E> {
            private final @NonNull Object substatements;

            protected WithSubstatements(D declared, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared, ctx, substatements);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class DefaultArgument<A, D extends DeclaredStatement<A>>
    extends Default<A, D> {
        protected DefaultArgument(D declared) {
            super(declared);
        }

        public final A argument() {
            return (A)this.getDeclared().argument();
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>>
        extends DefaultArgument<A, D> {
            private final @NonNull Object substatements;

            protected WithSubstatements(D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class DefaultDataNodeContainer<A, D extends DeclaredStatement<A>>
    extends Default<A, D>
    implements EffectiveStatementMixins.DataNodeContainerMixin<A, D> {
        private final @NonNull ImmutableMap<QName, DataSchemaNode> dataChildren;
        private final @NonNull Object substatements;

        protected DefaultDataNodeContainer(D declared, StatementSourceReference ref, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            super(declared);
            this.substatements = DefaultDataNodeContainer.maskList(substatements);
            HashMap<QName, DataSchemaNode> tmp = new HashMap<QName, DataSchemaNode>();
            for (EffectiveStatement stmt : this.effectiveSubstatements()) {
                if (!(stmt instanceof DataSchemaNode)) continue;
                DataSchemaNode node = (DataSchemaNode)stmt;
                QName id = node.getQName();
                DataSchemaNode prev = tmp.put(id, node);
                SourceException.throwIf((prev != null ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Cannot add child with name %s, a conflicting child already exists", (Object[])new Object[]{id});
            }
            this.dataChildren = ImmutableMap.copyOf(tmp);
        }

        public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return DefaultDataNodeContainer.unmaskList(this.substatements);
        }

        public final Optional<DataSchemaNode> findDataChildByName(QName name) {
            return Optional.ofNullable((DataSchemaNode)this.dataChildren.get((Object)Objects.requireNonNull(name)));
        }
    }

    public static abstract class Default<A, D extends DeclaredStatement<A>>
    extends AbstractDeclaredEffectiveStatement<A, D> {
        private final @NonNull D declared;

        protected Default(D declared) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
        }

        @Override
        public final D getDeclared() {
            return this.declared;
        }
    }

    public static abstract class WithDataTree<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
    extends WithSchemaTree<A, D, E> {
        @Override
        protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
            if (DataTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
                return Optional.of(this.dataTreeNamespace());
            }
            return super.getNamespaceContents(namespace);
        }

        protected abstract Map<QName, DataTreeEffectiveStatement<?>> dataTreeNamespace();
    }

    public static abstract class WithSchemaTree<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
    extends AbstractDeclaredEffectiveStatement<A, D> {
        @Override
        protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
            if (SchemaTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
                return Optional.of(this.schemaTreeNamespace());
            }
            return super.getNamespaceContents(namespace);
        }

        protected final Optional<DataSchemaNode> findDataSchemaNode(QName name) {
            Verify.verify((boolean)(this instanceof DataNodeContainer));
            SchemaTreeEffectiveStatement<?> child = this.schemaTreeNamespace().get(Objects.requireNonNull(name));
            return child instanceof DataSchemaNode ? Optional.of((DataSchemaNode)child) : Optional.empty();
        }

        protected abstract Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace();
    }
}

