/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractEffectiveDocumentedNodeWithStatus<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveDocumentedNode<A, D>
implements DocumentedNode.WithStatus {
    private static final VarHandle UNKNOWN_NODES;
    private final @NonNull Status status = this.findFirstEffectiveSubstatementArgument(StatusEffectiveStatement.class).orElse(Status.CURRENT);
    private volatile ImmutableList<UnknownSchemaNode> unknownNodes;

    protected AbstractEffectiveDocumentedNodeWithStatus(StmtContext<A, D, ?> ctx) {
        super(ctx);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
        ImmutableList<UnknownSchemaNode> existing = UNKNOWN_NODES.getAcquire(this);
        return existing != null ? existing : this.loadUnknownSchemaNodes();
    }

    private @NonNull ImmutableList<UnknownSchemaNode> loadUnknownSchemaNodes() {
        ArrayList<UnknownSchemaNode> init = new ArrayList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            init.add((UnknownSchemaNode)stmt);
        }
        ImmutableList computed = ImmutableList.copyOf(init);
        Object witness = UNKNOWN_NODES.compareAndExchangeRelease(this, null, computed);
        return witness == null ? computed : (ImmutableList)witness;
    }

    static {
        try {
            UNKNOWN_NODES = MethodHandles.lookup().findVarHandle(AbstractEffectiveDocumentedNodeWithStatus.class, "unknownNodes", ImmutableList.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

