/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.ContactEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrganizationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.NotificationNodeContainerCompat;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNodeWithStatus;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractEffectiveModule<D extends DeclaredStatement<String>, E extends DataTreeAwareEffectiveStatement<String, D>>
extends AbstractEffectiveDocumentedNodeWithStatus<String, D>
implements Module,
NotificationNodeContainerCompat<String, D, E> {
    private final String name;
    private final String prefix;
    private final YangVersion yangVersion;
    private final String organization;
    private final String contact;
    private final ImmutableSet<ModuleImport> imports;
    private final ImmutableSet<FeatureDefinition> features;
    private final @NonNull ImmutableSet<NotificationDefinition> notifications;
    private final ImmutableSet<AugmentationSchemaNode> augmentations;
    private final ImmutableSet<RpcDefinition> rpcs;
    private final ImmutableSet<Deviation> deviations;
    private final ImmutableList<ExtensionDefinition> extensionNodes;
    private final ImmutableSet<IdentitySchemaNode> identities;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;
    private final ImmutableSet<DataSchemaNode> publicChildNodes;
    private final SemVer semanticVersion;
    private final ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace;

    protected AbstractEffectiveModule(@NonNull StmtContext<String, D, ? extends EffectiveStatement<String, ?>> ctx, @NonNull String prefix) {
        super(ctx);
        Map<QName, SchemaTreeEffectiveStatement<?>> schemaTree = AbstractEffectiveModule.createSchemaTreeNamespace(ctx.getStatementSourceReference(), this.effectiveSubstatements());
        this.schemaTreeNamespace = ImmutableMap.copyOf(schemaTree);
        AbstractEffectiveModule.createDataTreeNamespace(ctx.getStatementSourceReference(), schemaTree.values(), this.schemaTreeNamespace);
        this.name = (String)this.argument();
        this.prefix = Objects.requireNonNull(prefix);
        this.yangVersion = this.findFirstEffectiveSubstatementArgument(YangVersionEffectiveStatement.class).orElse(YangVersion.VERSION_1);
        this.semanticVersion = this.findFirstEffectiveSubstatementArgument(OpenConfigVersionEffectiveStatement.class).orElse(null);
        this.organization = this.findFirstEffectiveSubstatementArgument(OrganizationEffectiveStatement.class).orElse(null);
        this.contact = this.findFirstEffectiveSubstatementArgument(ContactEffectiveStatement.class).orElse(null);
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        LinkedHashSet<ModuleImport> importsInit = new LinkedHashSet<ModuleImport>();
        LinkedHashSet<NotificationDefinition> notificationsInit = new LinkedHashSet<NotificationDefinition>();
        LinkedHashSet<RpcDefinition> rpcsInit = new LinkedHashSet<RpcDefinition>();
        LinkedHashSet<Deviation> deviationsInit = new LinkedHashSet<Deviation>();
        LinkedHashSet<IdentitySchemaNode> identitiesInit = new LinkedHashSet<IdentitySchemaNode>();
        LinkedHashSet<FeatureDefinition> featuresInit = new LinkedHashSet<FeatureDefinition>();
        ArrayList<ExtensionDefinition> extensionNodesInit = new ArrayList<ExtensionDefinition>();
        LinkedHashSet<GroupingDefinition> mutableGroupings = new LinkedHashSet<GroupingDefinition>();
        LinkedHashSet<UsesNode> mutableUses = new LinkedHashSet<UsesNode>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        LinkedHashSet<DataSchemaNode> mutablePublicChildNodes = new LinkedHashSet<DataSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            TypeDefinition type;
            if (effectiveStatement instanceof AugmentationSchemaNode) {
                augmentationsInit.add((AugmentationSchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof ModuleImport) {
                importsInit.add((ModuleImport)effectiveStatement);
            }
            if (effectiveStatement instanceof NotificationDefinition) {
                notificationsInit.add((NotificationDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof RpcDefinition) {
                rpcsInit.add((RpcDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof Deviation) {
                deviationsInit.add((Deviation)effectiveStatement);
            }
            if (effectiveStatement instanceof IdentitySchemaNode) {
                identitiesInit.add((IdentitySchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof FeatureDefinition) {
                featuresInit.add((FeatureDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof ExtensionDefinition) {
                extensionNodesInit.add((ExtensionDefinition)effectiveStatement);
            }
            if (effectiveStatement instanceof DataSchemaNode) {
                mutablePublicChildNodes.add((DataSchemaNode)effectiveStatement);
            }
            if (effectiveStatement instanceof UsesNode && !mutableUses.add((UsesNode)effectiveStatement)) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
            }
            if (effectiveStatement instanceof TypedefEffectiveStatement && !mutableTypeDefinitions.add(type = ((TypedefEffectiveStatement)effectiveStatement).getTypeDefinition())) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
            }
            if (!(effectiveStatement instanceof GroupingDefinition) || mutableGroupings.add((GroupingDefinition)effectiveStatement)) continue;
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
        }
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.imports = ImmutableSet.copyOf(importsInit);
        this.notifications = ImmutableSet.copyOf(notificationsInit);
        this.rpcs = ImmutableSet.copyOf(rpcsInit);
        this.deviations = ImmutableSet.copyOf(deviationsInit);
        this.identities = ImmutableSet.copyOf(identitiesInit);
        this.features = ImmutableSet.copyOf(featuresInit);
        this.extensionNodes = ImmutableList.copyOf(extensionNodesInit);
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.publicChildNodes = ImmutableSet.copyOf(mutablePublicChildNodes);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public URI getNamespace() {
        return this.getQNameModule().getNamespace();
    }

    public String getName() {
        return this.name;
    }

    public Optional<Revision> getRevision() {
        return this.getQNameModule().getRevision();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public YangVersion getYangVersion() {
        return this.yangVersion;
    }

    public Optional<String> getOrganization() {
        return Optional.ofNullable(this.organization);
    }

    public Optional<String> getContact() {
        return Optional.ofNullable(this.contact);
    }

    public Collection<? extends ModuleImport> getImports() {
        return this.imports;
    }

    public Collection<? extends FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Collection<? extends NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Collection<? extends AugmentationSchemaNode> getAugmentations() {
        return this.augmentations;
    }

    public Collection<? extends RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Collection<? extends Deviation> getDeviations() {
        return this.deviations;
    }

    public Collection<? extends ExtensionDefinition> getExtensionSchemaNodes() {
        return this.extensionNodes;
    }

    public Collection<? extends IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public final Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Collection<? extends DataSchemaNode> getChildNodes() {
        return this.publicChildNodes;
    }

    public final Collection<? extends GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        SchemaTreeEffectiveStatement child = (SchemaTreeEffectiveStatement)this.schemaTreeNamespace.get((Object)Objects.requireNonNull(name));
        return child instanceof DataSchemaNode ? Optional.of((DataSchemaNode)child) : Optional.empty();
    }

    public Collection<? extends UsesNode> getUses() {
        return this.uses;
    }

    public Optional<SemVer> getSemanticVersion() {
        return Optional.ofNullable(this.semanticVersion);
    }

    @Override
    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
        if (SchemaTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
            return Optional.of(this.schemaTreeNamespace);
        }
        return super.getNamespaceContents(namespace);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("namespace", (Object)this.getNamespace()).add("revision", this.getRevision().orElse(null)).add("prefix", (Object)this.prefix).add("yangVersion", (Object)this.yangVersion).toString();
    }

    protected static final @NonNull String findPrefix(@NonNull StmtContext<?, ?, ?> ctx, String type, String name) {
        return (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)ctx.declaredSubstatements(), PrefixStatement.class)), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to resolve prefix for %s %s.", (Object[])new Object[]{type, name});
    }

    protected final void appendPrefixes(StmtContext<?, ?, ?> ctx, ImmutableMap.Builder<String, ModuleEffectiveStatement> builder) {
        this.streamEffectiveSubstatements(ImportEffectiveStatement.class).map(imp -> (String)imp.findFirstEffectiveSubstatementArgument(PrefixEffectiveStatement.class).get()).forEach(pfx -> {
            StmtContext importedCtx = (StmtContext)Verify.verifyNotNull((Object)((StmtContext)ctx.getFromNamespace(ImportPrefixToModuleCtx.class, pfx)), (String)"Failed to resolve prefix %s", (Object[])new Object[]{pfx});
            builder.put(pfx, (Object)((ModuleEffectiveStatement)importedCtx.buildEffective()));
        });
    }
}

