/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractModelStatement;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractModelStatement<A>
implements EffectiveStatement<A, D> {
    public final <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends V> get(Class<N> namespace, K identifier) {
        return Optional.ofNullable(this.getAll(namespace).get(Objects.requireNonNull(identifier)));
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
        Optional<Map<K, V>> ret = this.getNamespaceContents(Objects.requireNonNull(namespace));
        return ret.isPresent() ? ret.get() : ImmutableMap.of();
    }

    public Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return ImmutableList.of();
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(@NonNull Class<N> namespace) {
        return Optional.empty();
    }

    protected static final @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> unmaskList(@NonNull Object masked) {
        return AbstractEffectiveStatement.unmaskList(masked, EffectiveStatement.class);
    }

    static @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> createSchemaTreeNamespace(StatementSourceReference ref, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        LinkedHashMap schemaChildren = new LinkedHashMap();
        substatements.stream().filter(SchemaTreeEffectiveStatement.class::isInstance).forEach(child -> AbstractEffectiveStatement.putChild(schemaChildren, (SchemaTreeEffectiveStatement)child, ref, "schema"));
        return schemaChildren;
    }

    static @NonNull ImmutableMap<QName, DataTreeEffectiveStatement<?>> createDataTreeNamespace(StatementSourceReference ref, Collection<SchemaTreeEffectiveStatement<?>> schemaTreeStatements, ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace) {
        LinkedHashMap dataChildren = new LinkedHashMap();
        boolean sameAsSchema = true;
        for (SchemaTreeEffectiveStatement<?> child : schemaTreeStatements) {
            if (child instanceof DataTreeEffectiveStatement) {
                AbstractEffectiveStatement.putChild(dataChildren, (DataTreeEffectiveStatement)child, ref, "data");
                continue;
            }
            sameAsSchema = false;
            AbstractEffectiveStatement.putChoiceDataChildren(dataChildren, ref, child);
        }
        return sameAsSchema ? schemaTreeNamespace : ImmutableMap.copyOf(dataChildren);
    }

    private static <T extends SchemaTreeEffectiveStatement<?>> void putChild(Map<QName, T> map, T child, StatementSourceReference ref, String tree) {
        QName id = child.getIdentifier();
        SchemaTreeEffectiveStatement prev = (SchemaTreeEffectiveStatement)map.putIfAbsent(id, child);
        SourceException.throwIf((prev != null ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Cannot add %s tree child with name %s, a conflicting child already exists", (Object[])new Object[]{tree, id});
    }

    private static void putChoiceDataChildren(Map<QName, DataTreeEffectiveStatement<?>> map, StatementSourceReference ref, SchemaTreeEffectiveStatement<?> child) {
        if (child instanceof ChoiceEffectiveStatement) {
            child.streamEffectiveSubstatements(CaseEffectiveStatement.class).forEach(caseStmt -> caseStmt.streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).forEach(stmt -> {
                if (stmt instanceof DataTreeEffectiveStatement) {
                    AbstractEffectiveStatement.putChild(map, (DataTreeEffectiveStatement)stmt, ref, "data");
                } else {
                    AbstractEffectiveStatement.putChoiceDataChildren(map, ref, stmt);
                }
            }));
        }
    }
}

