/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractUndeclaredEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveStatement<A, D> {
    public final StatementSource getStatementSource() {
        return StatementSource.CONTEXT;
    }

    public final D getDeclared() {
        return null;
    }

    public static abstract class DefaultWithDataTree<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
    extends WithDataTree<A, D, E> {
        private final @NonNull ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull ImmutableMap<QName, DataTreeEffectiveStatement<?>> dataTree;

        protected DefaultWithDataTree(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            StatementSourceReference ref = ctx.getStatementSourceReference();
            Map<QName, SchemaTreeEffectiveStatement<?>> schema = DefaultWithDataTree.createSchemaTreeNamespace(ref, substatements);
            this.schemaTree = ImmutableMap.copyOf(schema);
            this.dataTree = DefaultWithDataTree.createDataTreeNamespace(ref, schema.values(), this.schemaTree);
        }

        @Override
        protected final Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace() {
            return this.schemaTree;
        }

        @Override
        protected final Map<QName, DataTreeEffectiveStatement<?>> dataTreeNamespace() {
            return this.dataTree;
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
        extends DefaultWithDataTree<A, D, E> {
            private final @NonNull Object substatements;

            protected WithSubstatements(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(ctx, substatements);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class DefaultWithSchemaTree<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
    extends WithSchemaTree<A, D, E> {
        private final @NonNull ImmutableMap<QName, SchemaTreeEffectiveStatement<?>> schemaTree;

        protected DefaultWithSchemaTree(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.schemaTree = ImmutableMap.copyOf(DefaultWithSchemaTree.createSchemaTreeNamespace(ctx.getStatementSourceReference(), substatements));
        }

        @Override
        protected final Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace() {
            return this.schemaTree;
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
        extends DefaultWithSchemaTree<A, D, E> {
            private final @NonNull Object substatements;

            protected WithSubstatements(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(ctx, substatements);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithDataTree<A, D extends DeclaredStatement<A>, E extends DataTreeAwareEffectiveStatement<A, D>>
    extends WithSchemaTree<A, D, E> {
        @Override
        protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
            if (DataTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
                return Optional.of(this.dataTreeNamespace());
            }
            return super.getNamespaceContents(namespace);
        }

        protected abstract Map<QName, DataTreeEffectiveStatement<?>> dataTreeNamespace();
    }

    public static abstract class WithSchemaTree<A, D extends DeclaredStatement<A>, E extends SchemaTreeAwareEffectiveStatement<A, D>>
    extends AbstractUndeclaredEffectiveStatement<A, D> {
        @Override
        protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
            if (SchemaTreeAwareEffectiveStatement.Namespace.class.equals(namespace)) {
                return Optional.of(this.schemaTreeNamespace());
            }
            return super.getNamespaceContents(namespace);
        }

        protected final Optional<DataSchemaNode> findDataSchemaNode(QName name) {
            Verify.verify((boolean)(this instanceof DataNodeContainer));
            SchemaTreeEffectiveStatement<?> child = this.schemaTreeNamespace().get(Objects.requireNonNull(name));
            return child instanceof DataSchemaNode ? Optional.of((DataSchemaNode)child) : Optional.empty();
        }

        protected abstract Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace();
    }
}

