/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ArgumentUtils {
    public static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    public static final Splitter TWO_DOTS_SPLITTER = Splitter.on((String)"..").trimResults();
    private static final @Regex String PATH_ABS_STR = "/[^/].*";
    private static final Pattern PATH_ABS = Pattern.compile("/[^/].*");
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings().trimResults();
    private static final BigDecimal YANG_MIN_NUM = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final BigDecimal YANG_MAX_NUM = BigDecimal.valueOf(Double.MAX_VALUE);

    private ArgumentUtils() {
    }

    public static int compareNumbers(Number n1, Number n2) {
        BigDecimal num1 = ArgumentUtils.yangConstraintToBigDecimal(n1);
        BigDecimal num2 = ArgumentUtils.yangConstraintToBigDecimal(n2);
        return new BigDecimal(num1.toString()).compareTo(new BigDecimal(num2.toString()));
    }

    public static String internBoolean(String input) {
        if ("true".equals(input)) {
            return "true";
        }
        if ("false".equals(input)) {
            return "false";
        }
        return input;
    }

    public static @NonNull Boolean parseBoolean(StmtContext<?, ?, ?> ctx, String input) {
        if ("true".equals(input)) {
            return Boolean.TRUE;
        }
        if ("false".equals(input)) {
            return Boolean.FALSE;
        }
        StatementDefinition def = ctx.getPublicDefinition();
        throw new SourceException(ctx.getStatementSourceReference(), "Invalid '%s' statement %s '%s', it can be either 'true' or 'false'", new Object[]{def.getStatementName(), ((ArgumentDefinition)def.getArgumentDefinition().get()).getArgumentName(), input});
    }

    public static boolean isAbsoluteXPath(String path) {
        return PATH_ABS.matcher(path).matches();
    }

    public static SchemaNodeIdentifier.Absolute parseAbsoluteSchemaNodeIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        return SchemaNodeIdentifier.Absolute.of(ArgumentUtils.parseNodeIdentifiers(ctx, str));
    }

    public static SchemaNodeIdentifier.Descendant parseDescendantSchemaNodeIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        return SchemaNodeIdentifier.Descendant.of(ArgumentUtils.parseNodeIdentifiers(ctx, str));
    }

    public static SchemaNodeIdentifier nodeIdentifierFromPath(StmtContext<?, ?, ?> ctx, String path) {
        List<QName> qnames = ArgumentUtils.parseNodeIdentifiers(ctx, path);
        return PATH_ABS.matcher(path).matches() ? SchemaNodeIdentifier.Absolute.of(qnames) : SchemaNodeIdentifier.Descendant.of(qnames);
    }

    private static List<QName> parseNodeIdentifiers(StmtContext<?, ?, ?> ctx, String path) {
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (String nodeName : SLASH_SPLITTER.split((CharSequence)ArgumentUtils.trimSingleLastSlashFromXPath(path))) {
            try {
                qnames.add(StmtContextUtils.parseNodeIdentifier(ctx, (String)nodeName));
            }
            catch (RuntimeException e) {
                throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Failed to parse node '%s' in path '%s'", new Object[]{nodeName, path});
            }
        }
        if (qnames.isEmpty()) {
            throw new SourceException("Schema node identifier must not be empty", ctx.getStatementSourceReference());
        }
        return qnames;
    }

    private static String trimSingleLastSlashFromXPath(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    private static BigDecimal yangConstraintToBigDecimal(Number number) {
        if (UnresolvedNumber.max().equals(number)) {
            return YANG_MAX_NUM;
        }
        if (UnresolvedNumber.min().equals(number)) {
            return YANG_MIN_NUM;
        }
        return new BigDecimal(number.toString());
    }
}

