/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

final class StmtNamespaceContext
implements YangNamespaceContext {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Not passed to serialization")
    private final StmtContext<?, ?, ?> ctx;

    StmtNamespaceContext(StmtContext<?, ?, ?> ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    public Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return Optional.ofNullable((String)this.ctx.getFromNamespace(ModuleQNameToPrefix.class, (Object)namespace));
    }

    public Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        return Optional.ofNullable(StmtContextUtils.getModuleQNameByPrefix(this.ctx, (String)prefix));
    }
}

