/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class UndeclaredEffectiveStatementBase<A, D extends DeclaredStatement<A>>
extends EffectiveStatementBase<A, D> {
    private final @NonNull StatementSource statementSource;
    private final @NonNull StatementDefinition statementDefinition;
    private final A argument;

    protected UndeclaredEffectiveStatementBase(StmtContext<A, D, ?> ctx) {
        super(ctx);
        this.statementDefinition = ctx.getPublicDefinition();
        this.argument = ctx.getStatementArgument();
        this.statementSource = ctx.getStatementSource();
        DeclaredStatement declareInstance = ctx.buildDeclared();
        Verify.verify((declareInstance == null ? 1 : 0) != 0, (String)"Statement %s resulted in declared statement %s", (Object)declareInstance);
    }

    public final StatementDefinition statementDefinition() {
        return this.statementDefinition;
    }

    public final A argument() {
        return this.argument;
    }

    public final StatementSource getStatementSource() {
        return this.statementSource;
    }

    public final D getDeclared() {
        return null;
    }
}

