/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml.EmptyAnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml.EmptyAnyxmlStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml.RegularAnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anyxml.RegularAnyxmlStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class AnyxmlStatementSupport
extends BaseQNameStatementSupport<AnyxmlStatement, AnyxmlEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ANYXML).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final AnyxmlStatementSupport INSTANCE = new AnyxmlStatementSupport();

    private AnyxmlStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ANYXML);
    }

    public static AnyxmlStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, AnyxmlStatement, AnyxmlEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected AnyxmlStatement createDeclared(StmtContext<QName, AnyxmlStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularAnyxmlStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected AnyxmlStatement createEmptyDeclared(StmtContext<QName, AnyxmlStatement, ?> ctx) {
        return new EmptyAnyxmlStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected AnyxmlEffectiveStatement createEffective(StmtContext<QName, AnyxmlStatement, AnyxmlEffectiveStatement> ctx, AnyxmlStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularAnyxmlEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), AnyxmlStatementSupport.computeFlags(ctx, substatements), AnyxmlStatementSupport.findOriginal(ctx), substatements);
    }

    @Override
    protected AnyxmlEffectiveStatement createEmptyEffective(StmtContext<QName, AnyxmlStatement, AnyxmlEffectiveStatement> ctx, AnyxmlStatement declared) {
        return new EmptyAnyxmlEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), AnyxmlStatementSupport.computeFlags(ctx, ImmutableList.of()), AnyxmlStatementSupport.findOriginal(ctx));
    }

    private static int computeFlags(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AnyxmlStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setMandatory(AnyxmlStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, Boolean.FALSE)).toFlags();
    }

    private static @Nullable AnyxmlSchemaNode findOriginal(StmtContext<?, ?, ?> ctx) {
        return ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
    }
}

