/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice.ChoiceEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice.EmptyChoiceStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice.RegularChoiceStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImplicitParentAwareStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractChoiceStatementSupport
extends BaseQNameStatementSupport<ChoiceStatement, ChoiceEffectiveStatement>
implements ImplicitParentAwareStatementSupport {
    AbstractChoiceStatementSupport() {
        super((StatementDefinition)YangStmtMapping.CHOICE);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final Optional<StatementSupport<?, ?, ?>> getImplicitParentFor(StatementDefinition stmtDef) {
        return YangValidationBundles.SUPPORTED_CASE_SHORTHANDS.contains(stmtDef) ? Optional.of(this.implictCase()) : Optional.empty();
    }

    public final void onStatementAdded(StmtContext.Mutable<QName, ChoiceStatement, ChoiceEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    @Override
    protected final ChoiceStatement createDeclared(@NonNull StmtContext<QName, ChoiceStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularChoiceStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final ChoiceStatement createEmptyDeclared(@NonNull StmtContext<QName, ChoiceStatement, ?> ctx) {
        return new EmptyChoiceStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final ChoiceEffectiveStatement createEffective(StmtContext<QName, ChoiceStatement, ChoiceEffectiveStatement> ctx, ChoiceStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        CaseSchemaNode defaultCase;
        String defaultArg = AbstractChoiceStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        if (defaultArg != null) {
            QName qname;
            try {
                qname = QName.create((QName)((QName)ctx.coerceStatementArgument()), (String)defaultArg);
            }
            catch (IllegalArgumentException e) {
                throw new SourceException(ctx.getStatementSourceReference(), "Default statement has invalid name '%s'", new Object[]{defaultArg, e});
            }
            defaultCase = (CaseSchemaNode)InferenceException.throwIfNull((Object)AbstractChoiceStatementSupport.findCase(qname, substatements), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Default statement refers to missing case %s", (Object[])new Object[]{qname});
        } else {
            defaultCase = null;
        }
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractChoiceStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setMandatory(AbstractChoiceStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, Boolean.FALSE)).toFlags();
        return new ChoiceEffectiveStatementImpl(declared, ctx, substatements, flags, defaultCase, ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null));
    }

    @Override
    protected final ChoiceEffectiveStatement createEmptyEffective(StmtContext<QName, ChoiceStatement, ChoiceEffectiveStatement> ctx, ChoiceStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    abstract StatementSupport<?, ?, ?> implictCase();

    private static CaseSchemaNode findCase(QName qname, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        for (EffectiveStatement effectiveStatement : substatements) {
            CaseSchemaNode choiceCaseNode;
            if (!(effectiveStatement instanceof CaseSchemaNode) || !qname.equals((Object)(choiceCaseNode = (CaseSchemaNode)effectiveStatement).getQName())) continue;
            return choiceCaseNode;
        }
        return null;
    }
}

