/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.ActionNodeContainerCompat;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.NotificationNodeContainerCompat;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class ContainerEffectiveStatementImpl
extends AbstractDeclaredEffectiveStatement.DefaultWithDataTree.WithSubstatements<QName, ContainerStatement, ContainerEffectiveStatement>
implements ContainerEffectiveStatement,
ContainerSchemaNode,
DerivableSchemaNode,
EffectiveStatementMixins.DataSchemaNodeMixin<QName, ContainerStatement>,
EffectiveStatementMixins.DataNodeContainerMixin<QName, ContainerStatement>,
EffectiveStatementMixins.ActionNodeContainerMixin<QName, ContainerStatement>,
ActionNodeContainerCompat<QName, ContainerStatement, ContainerEffectiveStatement>,
EffectiveStatementMixins.NotificationNodeContainerMixin<QName, ContainerStatement>,
NotificationNodeContainerCompat<QName, ContainerStatement, ContainerEffectiveStatement>,
EffectiveStatementMixins.MustConstraintMixin<QName, ContainerStatement>,
EffectiveStatementMixins.PresenceMixin<QName, ContainerStatement>,
EffectiveStatementMixins.AugmentationTargetMixin<QName, ContainerStatement> {
    private final int flags;
    private final @NonNull SchemaPath path;
    private final @Nullable ContainerSchemaNode original;

    ContainerEffectiveStatementImpl(ContainerStatement declared, SchemaPath path, int flags, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, ContainerSchemaNode original) {
        super(declared, ctx, substatements);
        EffectiveStmtUtils.checkUniqueGroupings(ctx, substatements);
        EffectiveStmtUtils.checkUniqueTypedefs(ctx, substatements);
        EffectiveStmtUtils.checkUniqueUses(ctx, substatements);
        this.path = Objects.requireNonNull(path);
        this.original = original;
        this.flags = flags;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    public QName argument() {
        return this.getQName();
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }

    public Optional<ContainerSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public boolean isPresenceContainer() {
        return this.presence();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return this.findDataSchemaNode(name);
    }

    public String toString() {
        return "container " + this.getQName().getLocalName();
    }
}

