/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.RecursiveObjectLeaker;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNodeWithStatus;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class ExtensionEffectiveStatementImpl
extends AbstractEffectiveDocumentedNodeWithStatus<QName, ExtensionStatement>
implements ExtensionDefinition,
ExtensionEffectiveStatement {
    private static final RecursionDetector TOSTRING_DETECTOR = new RecursionDetector();
    private final @NonNull QName qname;
    private final @Nullable String argument;
    private final @NonNull SchemaPath schemaPath;
    private final boolean yin;

    private ExtensionEffectiveStatementImpl(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx) {
        super(ctx);
        this.qname = (QName)ctx.coerceStatementArgument();
        this.schemaPath = (SchemaPath)ctx.getSchemaPath().get();
        Optional optArgumentSubstatement = this.findFirstEffectiveSubstatement(ArgumentEffectiveStatement.class);
        if (optArgumentSubstatement.isPresent()) {
            ArgumentEffectiveStatement argumentStatement = (ArgumentEffectiveStatement)optArgumentSubstatement.get();
            this.argument = ((QName)argumentStatement.argument()).getLocalName();
            this.yin = argumentStatement.findFirstEffectiveSubstatement(YinElementEffectiveStatement.class).map(ModelStatement::argument).orElse(Boolean.FALSE);
        } else {
            this.argument = null;
            this.yin = false;
        }
    }

    static ExtensionEffectiveStatement create(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx) {
        ExtensionEffectiveStatementImpl existing = (ExtensionEffectiveStatementImpl)RecursiveObjectLeaker.lookup(ctx, ExtensionEffectiveStatementImpl.class);
        if (existing != null) {
            return existing;
        }
        RecursiveObjectLeaker.beforeConstructor(ctx);
        try {
            ExtensionEffectiveStatementImpl extensionEffectiveStatementImpl = new ExtensionEffectiveStatementImpl(ctx);
            return extensionEffectiveStatementImpl;
        }
        finally {
            RecursiveObjectLeaker.afterConstructor(ctx);
        }
    }

    @Override
    protected Collection<? extends EffectiveStatement<?, ?>> initSubstatements(Collection<? extends StmtContext<?, ?, ?>> substatementsInit) {
        RecursiveObjectLeaker.inConstructor((Object)this);
        return super.initSubstatements(substatementsInit);
    }

    public QName getQName() {
        return this.qname;
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    public String getArgument() {
        return this.argument;
    }

    public boolean isYinElement() {
        return this.yin;
    }

    public String toString() {
        if (TOSTRING_DETECTOR.check(this)) {
            return this.recursedToString();
        }
        TOSTRING_DETECTOR.push(this);
        try {
            String string = ExtensionEffectiveStatementImpl.class.getSimpleName() + "[argument=" + this.argument + ", qname=" + this.qname + ", schemaPath=" + this.schemaPath + ", extensionSchemaNodes=" + this.getUnknownSchemaNodes() + ", yin=" + this.yin + "]";
            return string;
        }
        finally {
            TOSTRING_DETECTOR.pop();
        }
    }

    private String recursedToString() {
        return ExtensionEffectiveStatementImpl.class.getSimpleName() + "[argument=" + this.argument + ", qname=" + this.qname + ", schemaPath=" + this.schemaPath + ", yin=" + this.yin + " <RECURSIVE> ]";
    }

    private static final class RecursionDetector
    extends ThreadLocal<Deque<ExtensionEffectiveStatementImpl>> {
        private RecursionDetector() {
        }

        boolean check(ExtensionEffectiveStatementImpl current) {
            Deque stack = (Deque)this.get();
            if (stack != null) {
                for (ExtensionEffectiveStatementImpl s : stack) {
                    if (s != current) continue;
                    return true;
                }
            }
            return false;
        }

        void push(ExtensionEffectiveStatementImpl current) {
            ArrayDeque<ExtensionEffectiveStatementImpl> stack = (ArrayDeque<ExtensionEffectiveStatementImpl>)this.get();
            if (stack == null) {
                stack = new ArrayDeque<ExtensionEffectiveStatementImpl>(1);
                this.set(stack);
            }
            stack.push(current);
        }

        void pop() {
            Deque stack = (Deque)this.get();
            stack.pop();
            if (stack.isEmpty()) {
                this.remove();
            }
        }
    }
}

