/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ExtensionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ExtensionStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementDefinitionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class ExtensionStatementSupport
extends AbstractQNameStatementSupport<ExtensionStatement, ExtensionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.EXTENSION).addOptional((StatementDefinition)YangStmtMapping.ARGUMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    private static final ExtensionStatementSupport INSTANCE = new ExtensionStatementSupport();

    private ExtensionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.EXTENSION);
    }

    public static ExtensionStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public ExtensionStatement createDeclared(StmtContext<QName, ExtensionStatement, ?> ctx) {
        return new ExtensionStatementImpl(ctx);
    }

    public ExtensionEffectiveStatement createEffective(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx) {
        return ExtensionEffectiveStatementImpl.create(ctx);
    }

    public void onStatementDefinitionDeclared(StmtContext.Mutable<QName, ExtensionStatement, ExtensionEffectiveStatement> stmt) {
        super.onStatementDefinitionDeclared(stmt);
        QName stmtName = (QName)stmt.coerceStatementArgument();
        if (OpenConfigStatements.OPENCONFIG_VERSION.getStatementName().isEqualWithoutRevision(stmtName)) {
            stmtName = stmtName.withoutRevision();
        }
        stmt.addContext(ExtensionNamespace.class, (Object)stmtName, stmt);
        StmtContext argument = StmtContextUtils.findFirstDeclaredSubstatement(stmt, ArgumentStatement.class);
        StmtContext yinElement = StmtContextUtils.findFirstDeclaredSubstatement(stmt, YinElementStatement.class);
        stmt.addToNs(StatementDefinitionNamespace.class, (Object)((QName)stmt.getStatementArgument()), (Object)new ModelDefinedStatementSupport(new ModelDefinedStatementDefinition((QName)stmt.getStatementArgument(), argument != null ? (QName)argument.getStatementArgument() : null, yinElement != null && (Boolean)yinElement.getStatementArgument() != false)));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

