/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity.EmptyIdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity.EmptyIdentityStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity.RegularIdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.identity.RegularIdentityStatement;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractIdentityStatementSupport
extends BaseQNameStatementSupport<IdentityStatement, IdentityEffectiveStatement> {
    AbstractIdentityStatementSupport() {
        super((StatementDefinition)YangStmtMapping.IDENTITY);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final void onStatementDefinitionDeclared(StmtContext.Mutable<QName, IdentityStatement, IdentityEffectiveStatement> stmt) {
        QName qname = (QName)stmt.coerceStatementArgument();
        StmtContext prev = (StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)qname);
        SourceException.throwIf((prev != null ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Duplicate identity definition %s", (Object[])new Object[]{qname});
        stmt.addToNs(IdentityNamespace.class, (Object)qname, stmt);
    }

    @Override
    protected final IdentityStatement createDeclared(StmtContext<QName, IdentityStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularIdentityStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final IdentityStatement createEmptyDeclared(@NonNull StmtContext<QName, IdentityStatement, ?> ctx) {
        return new EmptyIdentityStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final IdentityEffectiveStatement createEffective(StmtContext<QName, IdentityStatement, IdentityEffectiveStatement> ctx, IdentityStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        ArrayList<IdentitySchemaNode> identities = new ArrayList<IdentitySchemaNode>();
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof BaseEffectiveStatement)) continue;
            QName qname = (QName)((BaseEffectiveStatement)stmt).argument();
            IdentityEffectiveStatement identity = (IdentityEffectiveStatement)((StmtContext)Verify.verifyNotNull((Object)((StmtContext)ctx.getFromNamespace(IdentityNamespace.class, (Object)qname)), (String)"Failed to find identity %s", (Object[])new Object[]{qname})).buildEffective();
            Verify.verify((boolean)(identity instanceof IdentitySchemaNode), (String)"%s is not a IdentitySchemaNode", (Object)identity);
            identities.add((IdentitySchemaNode)identity);
        }
        return new RegularIdentityEffectiveStatement(declared, ctx, new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(AbstractIdentityStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags(), substatements, (ImmutableSet<? extends IdentitySchemaNode>)ImmutableSet.copyOf(identities));
    }

    @Override
    protected final IdentityEffectiveStatement createEmptyEffective(StmtContext<QName, IdentityStatement, IdentityEffectiveStatement> ctx, IdentityStatement declared) {
        return new EmptyIdentityEffectiveStatement(declared, ctx);
    }
}

