/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature;

import com.google.common.base.Verify;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureExpr;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature.IfFeatureEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature.IfFeaturePredicateVisitor;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature.IfFeatureStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.FeatureNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfFeatureStatementSupport
extends AbstractStatementSupport<IfFeatureExpr, IfFeatureStatement, IfFeatureEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(IfFeatureStatementSupport.class);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IF_FEATURE).build();
    private static final IfFeatureStatementSupport INSTANCE = new IfFeatureStatementSupport();

    private IfFeatureStatementSupport() {
        super((StatementDefinition)YangStmtMapping.IF_FEATURE, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static IfFeatureStatementSupport getInstance() {
        return INSTANCE;
    }

    public IfFeatureExpr parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        if (YangVersion.VERSION_1_1.equals((Object)ctx.getRootVersion())) {
            return IfFeaturePredicateVisitor.parseIfFeatureExpression(ctx, value);
        }
        return IfFeatureExpr.isPresent((QName)StmtContextUtils.parseNodeIdentifier(ctx, (String)value));
    }

    public void onFullDefinitionDeclared(final StmtContext.Mutable<IfFeatureExpr, IfFeatureStatement, IfFeatureEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        ModelActionBuilder verifyFeatures = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final HashMap<ModelActionBuilder.Prerequisite, QName> backRef = new HashMap<ModelActionBuilder.Prerequisite, QName>();
        for (QName feature : ((IfFeatureExpr)stmt.getStatementArgument()).getReferencedFeatures()) {
            backRef.put(verifyFeatures.requiresCtx(stmt, FeatureNamespace.class, (Object)feature, ModelProcessingPhase.EFFECTIVE_MODEL), feature);
        }
        verifyFeatures.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                LOG.debug("Resolved all feature references in {}", backRef.values());
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                HashSet<QName> unresolvedFeatures = new HashSet<QName>();
                for (ModelActionBuilder.Prerequisite<?> prereq : failed) {
                    unresolvedFeatures.add((QName)Verify.verifyNotNull((Object)((QName)backRef.get(prereq))));
                }
                throw new InferenceException(stmt.getStatementSourceReference(), "Failed to resolve feature references %s in \"%s\"", new Object[]{unresolvedFeatures, stmt.rawStatementArgument()});
            }
        });
    }

    public IfFeatureStatement createDeclared(StmtContext<IfFeatureExpr, IfFeatureStatement, ?> ctx) {
        return new IfFeatureStatementImpl(ctx);
    }

    public IfFeatureEffectiveStatement createEffective(StmtContext<IfFeatureExpr, IfFeatureStatement, IfFeatureEffectiveStatement> ctx) {
        return new IfFeatureEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

