/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include;

import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.IncludeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.IncludeStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.SubmoduleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractIncludeStatementSupport
extends AbstractStatementSupport<String, IncludeStatement, IncludeEffectiveStatement> {
    AbstractIncludeStatementSupport() {
        super((StatementDefinition)YangStmtMapping.INCLUDE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final IncludeStatement createDeclared(StmtContext<String, IncludeStatement, ?> ctx) {
        return new IncludeStatementImpl(ctx);
    }

    public final IncludeEffectiveStatement createEffective(StmtContext<String, IncludeStatement, IncludeEffectiveStatement> ctx) {
        return new IncludeEffectiveStatementImpl(ctx);
    }

    public final void onPreLinkageDeclared(StmtContext.Mutable<String, IncludeStatement, IncludeEffectiveStatement> stmt) {
        StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        stmt.addRequiredSource((SourceIdentifier)(revision == null ? RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument())) : RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Revision)((Revision)revision.getStatementArgument()))));
    }

    public final void onLinkageDeclared(final StmtContext.Mutable<String, IncludeStatement, IncludeEffectiveStatement> stmt) {
        final String submoduleName = (String)stmt.coerceStatementArgument();
        final StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        ModelActionBuilder includeAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite requiresCtxPrerequisite = revision == null ? includeAction.requiresCtx(stmt, SubmoduleNamespace.class, NamespaceKeyCriterion.latestRevisionModule((String)submoduleName), ModelProcessingPhase.SOURCE_LINKAGE) : includeAction.requiresCtx(stmt, SubmoduleNamespace.class, (Object)RevisionSourceIdentifier.create((String)submoduleName, Optional.of((Revision)revision.getStatementArgument())), ModelProcessingPhase.SOURCE_LINKAGE);
        includeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext includedSubModuleContext = (StmtContext)requiresCtxPrerequisite.resolve(ctx);
                stmt.addToNs(IncludedModuleContext.class, (Object)(revision != null ? RevisionSourceIdentifier.create((String)submoduleName, (Revision)((Revision)revision.getStatementArgument())) : RevisionSourceIdentifier.create((String)submoduleName)), (Object)includedSubModuleContext);
                stmt.addToNs(IncludedSubmoduleNameToModuleCtx.class, (Object)((String)stmt.getStatementArgument()), (Object)includedSubModuleContext);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(requiresCtxPrerequisite), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Included submodule '%s' was not found: ", (Object[])new Object[]{stmt.getStatementArgument()});
            }
        });
    }
}

