/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf.EmptyLeafEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf.EmptyLeafStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf.RegularLeafEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf.RegularLeafStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class LeafStatementSupport
extends BaseQNameStatementSupport<LeafStatement, LeafEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LEAF).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final LeafStatementSupport INSTANCE = new LeafStatementSupport();

    private LeafStatementSupport() {
        super((StatementDefinition)YangStmtMapping.LEAF);
    }

    public static LeafStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, LeafStatement, LeafEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, LeafStatement, LeafEffectiveStatement> ctx) {
        super.onFullDefinitionDeclared(ctx);
        StmtContextUtils.validateIfFeatureAndWhenOnListKeys(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected LeafStatement createDeclared(StmtContext<QName, LeafStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularLeafStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected LeafStatement createEmptyDeclared(StmtContext<QName, LeafStatement, ?> ctx) {
        return new EmptyLeafStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected LeafEffectiveStatement createEffective(StmtContext<QName, LeafStatement, LeafEffectiveStatement> ctx, LeafStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)LeafStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf is missing a 'type' statement", (Object[])new Object[0]);
        String dflt = LeafStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeStmt, dflt), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), dflt});
        SchemaPath path = (SchemaPath)ctx.getSchemaPath().get();
        LeafSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(LeafStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setMandatory(LeafStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, Boolean.FALSE)).toFlags();
        return original == null ? new EmptyLeafEffectiveStatement(declared, path, flags, substatements) : new RegularLeafEffectiveStatement(declared, path, flags, substatements, original);
    }

    @Override
    protected LeafEffectiveStatement createEmptyEffective(StmtContext<QName, LeafStatement, LeafEffectiveStatement> ctx, LeafStatement declared) {
        throw new UnsupportedOperationException("Leaf statements must have at least one substatement");
    }
}

