/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.length;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.length.LengthEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.length.LengthStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class LengthStatementSupport
extends AbstractStatementSupport<List<ValueRange>, LengthStatement, LengthEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final LengthStatementSupport INSTANCE = new LengthStatementSupport();

    private LengthStatementSupport() {
        super((StatementDefinition)YangStmtMapping.LENGTH, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static LengthStatementSupport getInstance() {
        return INSTANCE;
    }

    public List<ValueRange> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ArrayList<ValueRange> ranges = new ArrayList<ValueRange>();
        for (String singleRange : ArgumentUtils.PIPE_SPLITTER.split((CharSequence)value)) {
            Number max;
            Iterator boundaries = ArgumentUtils.TWO_DOTS_SPLITTER.split((CharSequence)singleRange).iterator();
            Number min = LengthStatementSupport.parseIntegerConstraintValue(ctx, (String)boundaries.next());
            if (boundaries.hasNext()) {
                max = LengthStatementSupport.parseIntegerConstraintValue(ctx, (String)boundaries.next());
                SourceException.throwIf((ArgumentUtils.compareNumbers(min, max) == 1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Length constraint %s has descending order of boundaries; should be ascending.", (Object[])new Object[]{singleRange});
                SourceException.throwIf((boolean)boundaries.hasNext(), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Wrong number of boundaries in length constraint %s.", (Object[])new Object[]{singleRange});
            } else {
                max = min;
            }
            InferenceException.throwIf((ranges.size() > 1 && ArgumentUtils.compareNumbers(min, ((ValueRange)Iterables.getLast(ranges)).upperBound()) != 1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Some of the length ranges in %s are not disjoint", (Object[])new Object[]{value});
            ranges.add(ValueRange.of((Number)min, (Number)max));
        }
        return ImmutableList.copyOf(ranges);
    }

    public LengthStatement createDeclared(StmtContext<List<ValueRange>, LengthStatement, ?> ctx) {
        return new LengthStatementImpl(ctx);
    }

    public LengthEffectiveStatement createEffective(StmtContext<List<ValueRange>, LengthStatement, LengthEffectiveStatement> ctx) {
        return new LengthEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    private static Number parseIntegerConstraintValue(StmtContext<?, ?, ?> ctx, String value) {
        if ("max".equals(value)) {
            return UnresolvedNumber.max();
        }
        if ("min".equals(value)) {
            return UnresolvedNumber.min();
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Value %s is not a valid integer", new Object[]{value});
        }
    }
}

