/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.ConfigListWarningNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.EmptyListEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.EmptyListStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.RegularListEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list.RegularListStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractListStatementSupport
extends BaseQNameStatementSupport<ListStatement, ListEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractListStatementSupport.class);
    private static final ImmutableSet<YangStmtMapping> UNINSTANTIATED_DATATREE_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.GROUPING, (Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.INPUT, (Object)YangStmtMapping.OUTPUT);

    AbstractListStatementSupport() {
        super((StatementDefinition)YangStmtMapping.LIST);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final void onStatementAdded(StmtContext.Mutable<QName, ListStatement, ListEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    @Override
    protected final ListStatement createDeclared(StmtContext<QName, ListStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularListStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final ListStatement createEmptyDeclared(StmtContext<QName, ListStatement, ?> ctx) {
        return new EmptyListStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final ListEffectiveStatement createEffective(StmtContext<QName, ListStatement, ListEffectiveStatement> ctx, ListStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        ImmutableList keyDefinition;
        SchemaPath path = (SchemaPath)ctx.getSchemaPath().get();
        ListSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        KeyEffectiveStatement keyStmt = AbstractListStatementSupport.findFirstStatement(substatements, KeyEffectiveStatement.class);
        if (keyStmt != null) {
            ArrayList<QName> keyDefinitionInit = new ArrayList<QName>(((Set)keyStmt.argument()).size());
            HashSet<QName> possibleLeafQNamesForKey = new HashSet<QName>();
            for (EffectiveStatement effectiveStatement : substatements) {
                if (!(effectiveStatement instanceof LeafSchemaNode)) continue;
                possibleLeafQNamesForKey.add(((LeafSchemaNode)effectiveStatement).getQName());
            }
            for (QName keyQName : (Set)keyStmt.argument()) {
                if (!possibleLeafQNamesForKey.contains(keyQName)) {
                    throw new InferenceException(ctx.getStatementSourceReference(), "Key '%s' misses node '%s' in list '%s'", new Object[]{((KeyStatement)keyStmt.getDeclared()).rawArgument(), keyQName.getLocalName(), ctx.getStatementArgument()});
                }
                keyDefinitionInit.add(keyQName);
            }
            keyDefinition = ImmutableList.copyOf(keyDefinitionInit);
        } else {
            keyDefinition = ImmutableList.of();
        }
        boolean configuration = ctx.isConfiguration();
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractListStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(configuration).setUserOrdered(AbstractListStatementSupport.findFirstArgument(substatements, OrderedByEffectiveStatement.class, OrderedByStatement.Ordering.SYSTEM).equals((Object)OrderedByStatement.Ordering.USER)).toFlags();
        if (configuration && keyDefinition.isEmpty() && AbstractListStatementSupport.isInstantied(ctx)) {
            AbstractListStatementSupport.warnConfigList(ctx);
        }
        Optional<ElementCountConstraint> elementCountConstraint = EffectiveStmtUtils.createElementCountConstraint(substatements);
        return original == null && !elementCountConstraint.isPresent() ? new EmptyListEffectiveStatement(declared, path, flags, ctx, substatements, (ImmutableList<QName>)keyDefinition) : new RegularListEffectiveStatement(declared, path, flags, ctx, substatements, (ImmutableList<QName>)keyDefinition, elementCountConstraint.orElse(null), original);
    }

    private static void warnConfigList(@NonNull StmtContext<QName, ListStatement, ListEffectiveStatement> ctx) {
        StmtContext<QName, ListStatement, ListEffectiveStatement> warnCtx = ctx.getOriginalCtx().orElse(ctx);
        Boolean warned = (Boolean)warnCtx.getFromNamespace(ConfigListWarningNamespace.class, (Object)Boolean.TRUE);
        if (warned == null) {
            Verify.verify((boolean)(warnCtx instanceof StmtContext.Mutable), (String)"Unexpected context %s", warnCtx);
            ((StmtContext.Mutable)warnCtx).addToNs(ConfigListWarningNamespace.class, (Object)Boolean.TRUE, (Object)Boolean.TRUE);
            LOG.info("Configuration list {} does not define any keys in violation of RFC7950 section 7.8.2. While this is fine with OpenDaylight, it can cause interoperability issues with other systems [defined at {}]", ctx.getStatementArgument(), (Object)warnCtx.getStatementSourceReference());
        }
    }

    private static boolean isInstantied(StmtContext<?, ?, ?> ctx) {
        for (StmtContext parent = ctx.getParentContext(); parent != null; parent = parent.getParentContext()) {
            if (!UNINSTANTIATED_DATATREE_STATEMENTS.contains((Object)parent.getPublicDefinition())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final ListEffectiveStatement createEmptyEffective(StmtContext<QName, ListStatement, ListEffectiveStatement> ctx, ListStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

