/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.min_elements;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.min_elements.EmptyMinElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.min_elements.EmptyMinElementsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.min_elements.RegularMinElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.min_elements.RegularMinElementsStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class MinElementsStatementSupport
extends BaseInternedStatementSupport<Integer, MinElementsStatement, MinElementsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).build();
    private static final MinElementsStatementSupport INSTANCE = new MinElementsStatementSupport();

    private MinElementsStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MIN_ELEMENTS);
    }

    public static MinElementsStatementSupport getInstance() {
        return INSTANCE;
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException("Invalid min-elements argument", ctx.getStatementSourceReference(), (Throwable)e);
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected MinElementsStatement createDeclared(Integer argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularMinElementsStatement(argument, substatements);
    }

    @Override
    protected MinElementsStatement createEmptyDeclared(Integer argument) {
        return new EmptyMinElementsStatement(argument);
    }

    @Override
    protected MinElementsEffectiveStatement createEffective(StmtContext<Integer, MinElementsStatement, MinElementsEffectiveStatement> ctx, MinElementsStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularMinElementsEffectiveStatement(declared, substatements);
    }

    @Override
    protected MinElementsEffectiveStatement createEmptyEffective(MinElementsStatement declared) {
        return new EmptyMinElementsEffectiveStatement(declared);
    }
}

