/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatementNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatementNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatementNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveModule;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.FeatureNamespace;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;

final class ModuleEffectiveStatementImpl
extends AbstractEffectiveModule<ModuleStatement, ModuleEffectiveStatement>
implements ModuleEffectiveStatement {
    private final ImmutableMap<String, SubmoduleEffectiveStatement> nameToSubmodule;
    private final ImmutableMap<QName, ExtensionEffectiveStatement> qnameToExtension;
    private final ImmutableMap<QName, FeatureEffectiveStatement> qnameToFeature;
    private final ImmutableMap<QName, IdentityEffectiveStatement> qnameToIdentity;
    private final ImmutableMap<String, ModuleEffectiveStatement> prefixToModule;
    private final ImmutableMap<QNameModule, String> namespaceToPrefix;
    private final @NonNull QNameModule qnameModule;
    private final ImmutableSet<Module> submodules;

    private ModuleEffectiveStatementImpl(@NonNull ModuleStmtContext ctx) {
        super(ctx, ModuleEffectiveStatementImpl.findPrefix(ctx.delegate(), "module", ctx.getStatementArgument()));
        this.submodules = ctx.getSubmodules();
        this.qnameModule = (QNameModule)Verify.verifyNotNull((Object)((QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, ctx.delegate())));
        String localPrefix = (String)this.findFirstEffectiveSubstatementArgument(PrefixEffectiveStatement.class).get();
        ImmutableMap.Builder prefixToModuleBuilder = ImmutableMap.builder();
        prefixToModuleBuilder.put((Object)localPrefix, (Object)this);
        this.appendPrefixes(ctx, (ImmutableMap.Builder<String, ModuleEffectiveStatement>)prefixToModuleBuilder);
        this.prefixToModule = prefixToModuleBuilder.build();
        LinkedHashMap tmp = Maps.newLinkedHashMapWithExpectedSize((int)(this.prefixToModule.size() + 1));
        tmp.put(this.qnameModule, localPrefix);
        for (Map.Entry e : this.prefixToModule.entrySet()) {
            tmp.putIfAbsent(((ModuleEffectiveStatement)e.getValue()).localQNameModule(), (String)e.getKey());
        }
        this.namespaceToPrefix = ImmutableMap.copyOf((Map)tmp);
        Map includedSubmodules = ctx.getAllFromCurrentStmtCtxNamespace(IncludedSubmoduleNameToModuleCtx.class);
        this.nameToSubmodule = includedSubmodules == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.transformValues(includedSubmodules, submodule -> (SubmoduleEffectiveStatement)submodule.buildEffective()));
        Map extensions = ctx.getAllFromCurrentStmtCtxNamespace(ExtensionNamespace.class);
        this.qnameToExtension = extensions == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.transformValues(extensions, StmtContext::buildEffective));
        Map features = ctx.getAllFromCurrentStmtCtxNamespace(FeatureNamespace.class);
        this.qnameToFeature = features == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.transformValues(features, StmtContext::buildEffective));
        Map identities = ctx.getAllFromCurrentStmtCtxNamespace(IdentityNamespace.class);
        this.qnameToIdentity = identities == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.transformValues(identities, StmtContext::buildEffective));
    }

    ModuleEffectiveStatementImpl(StmtContext<String, ModuleStatement, ModuleEffectiveStatement> ctx) {
        this(ModuleStmtContext.create(ctx));
    }

    public @NonNull QNameModule localQNameModule() {
        return this.qnameModule;
    }

    public @NonNull QNameModule getQNameModule() {
        return this.qnameModule;
    }

    public ImmutableSet<Module> getSubmodules() {
        return this.submodules;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(@NonNull Class<N> namespace) {
        if (ModuleEffectiveStatement.PrefixToEffectiveModuleNamespace.class.equals(namespace)) {
            return Optional.of(this.prefixToModule);
        }
        if (ModuleEffectiveStatement.QNameModuleToPrefixNamespace.class.equals(namespace)) {
            return Optional.of(this.namespaceToPrefix);
        }
        if (ModuleEffectiveStatement.NameToEffectiveSubmoduleNamespace.class.equals(namespace)) {
            return Optional.of(this.nameToSubmodule);
        }
        if (ExtensionEffectiveStatementNamespace.class.equals(namespace)) {
            return Optional.of(this.qnameToExtension);
        }
        if (FeatureEffectiveStatementNamespace.class.equals(namespace)) {
            return Optional.of(this.qnameToFeature);
        }
        if (IdentityEffectiveStatementNamespace.class.equals(namespace)) {
            return Optional.of(this.qnameToIdentity);
        }
        return super.getNamespaceContents(namespace);
    }
}

