/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import com.google.common.base.Verify;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class ModuleStmtContext
extends ForwardingObject
implements StmtContext<String, ModuleStatement, ModuleEffectiveStatement> {
    private final @NonNull StmtContext<String, ModuleStatement, ModuleEffectiveStatement> delegate;
    private final @NonNull ImmutableList<StmtContext<?, ?, ?>> effectiveSubstatements;
    private final @NonNull ImmutableSet<Module> submodules;

    private ModuleStmtContext(StmtContext<String, ModuleStatement, ModuleEffectiveStatement> delegate, Collection<StmtContext<?, ?, ?>> submodules) {
        this.delegate = Objects.requireNonNull(delegate);
        ArrayList<StmtContext> statements = new ArrayList<StmtContext>(delegate.effectiveSubstatements());
        LinkedHashSet<Module> subs = new LinkedHashSet<Module>(submodules.size());
        for (StmtContext<?, ?, ?> submoduleCtx : submodules) {
            EffectiveStatement submodule = submoduleCtx.buildEffective();
            Verify.verify((boolean)(submodule instanceof Module), (String)"Submodule statement %s is not a Module", (Object)submodule);
            subs.add((Module)submodule);
            for (StmtContext stmt : submoduleCtx.allSubstatements()) {
                EffectiveStatement effective;
                if (!stmt.isSupportedByFeatures() || !((effective = stmt.buildEffective()) instanceof SchemaNode) && !(effective instanceof DataNodeContainer)) continue;
                statements.add(stmt);
            }
        }
        this.effectiveSubstatements = ImmutableList.copyOf(statements);
        this.submodules = ImmutableSet.copyOf(subs);
    }

    static @NonNull ModuleStmtContext create(StmtContext<String, ModuleStatement, ModuleEffectiveStatement> delegate) {
        Map includedSubmodules = delegate.getAllFromCurrentStmtCtxNamespace(IncludedSubmoduleNameToModuleCtx.class);
        return new ModuleStmtContext(delegate, (Collection<StmtContext<?, ?, ?>>)(includedSubmodules == null || includedSubmodules.isEmpty() ? ImmutableList.of() : includedSubmodules.values()));
    }

    protected @NonNull StmtContext<String, ModuleStatement, ModuleEffectiveStatement> delegate() {
        return this.delegate;
    }

    ImmutableSet<Module> getSubmodules() {
        return this.submodules;
    }

    public ImmutableList<StmtContext<?, ?, ?>> effectiveSubstatements() {
        return this.effectiveSubstatements;
    }

    public ModuleEffectiveStatement buildEffective() {
        throw new UnsupportedOperationException("Attempted to instantiate proxy context " + this);
    }

    public ModuleStatement buildDeclared() {
        return (ModuleStatement)this.delegate.buildDeclared();
    }

    public StatementSource getStatementSource() {
        return this.delegate.getStatementSource();
    }

    public StatementSourceReference getStatementSourceReference() {
        return this.delegate.getStatementSourceReference();
    }

    public StatementDefinition getPublicDefinition() {
        return this.delegate.getPublicDefinition();
    }

    public StmtContext<?, ?, ?> getParentContext() {
        return this.delegate.getParentContext();
    }

    public String rawStatementArgument() {
        return this.delegate.rawStatementArgument();
    }

    public @Nullable String getStatementArgument() {
        return (String)this.delegate.getStatementArgument();
    }

    public @NonNull Optional<SchemaPath> getSchemaPath() {
        return this.delegate.getSchemaPath();
    }

    public boolean isConfiguration() {
        return this.delegate.isConfiguration();
    }

    public boolean isEnabledSemanticVersioning() {
        return this.delegate.isEnabledSemanticVersioning();
    }

    public <K, V, T extends K, N extends IdentifierNamespace<K, V>> V getFromNamespace(Class<N> type, T key) {
        return (V)this.delegate.getFromNamespace(type, key);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromNamespace(Class<N> type) {
        return this.delegate.getAllFromNamespace(type);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromCurrentStmtCtxNamespace(Class<N> type) {
        return this.delegate.getAllFromCurrentStmtCtxNamespace(type);
    }

    public StmtContext<?, ?, ?> getRoot() {
        return this.delegate.getRoot();
    }

    public Collection<? extends StmtContext<?, ?, ?>> declaredSubstatements() {
        return this.delegate.declaredSubstatements();
    }

    public boolean isSupportedToBuildEffective() {
        return this.delegate.isSupportedToBuildEffective();
    }

    public boolean isSupportedByFeatures() {
        return this.delegate.isSupportedByFeatures();
    }

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement() {
        return this.delegate.getEffectOfStatement();
    }

    public CopyHistory getCopyHistory() {
        return this.delegate.getCopyHistory();
    }

    public Optional<StmtContext<String, ModuleStatement, ModuleEffectiveStatement>> getOriginalCtx() {
        return this.delegate.getOriginalCtx();
    }

    public Optional<StmtContext<String, ModuleStatement, ModuleEffectiveStatement>> getPreviousCopyCtx() {
        return this.delegate.getPreviousCopyCtx();
    }

    public ModelProcessingPhase getCompletedPhase() {
        return this.delegate.getCompletedPhase();
    }

    public @NonNull YangVersion getRootVersion() {
        return this.delegate.getRootVersion();
    }
}

