/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.EmptyNotificationStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.NotificationEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification.RegularNotificationStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

abstract class AbstractNotificationStatementSupport
extends BaseQNameStatementSupport<NotificationStatement, NotificationEffectiveStatement> {
    AbstractNotificationStatementSupport() {
        super((StatementDefinition)YangStmtMapping.NOTIFICATION);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final void onStatementAdded(StmtContext.Mutable<QName, NotificationStatement, NotificationEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    @Override
    protected final NotificationStatement createDeclared(StmtContext<QName, NotificationStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularNotificationStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final NotificationStatement createEmptyDeclared(StmtContext<QName, NotificationStatement, ?> ctx) {
        return new EmptyNotificationStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final NotificationEffectiveStatement createEffective(StmtContext<QName, NotificationStatement, NotificationEffectiveStatement> ctx, NotificationStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        this.checkEffective(ctx);
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractNotificationStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
        return new NotificationEffectiveStatementImpl(declared, flags, ctx, substatements);
    }

    @Override
    protected final NotificationEffectiveStatement createEmptyEffective(StmtContext<QName, NotificationStatement, NotificationEffectiveStatement> ctx, NotificationStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    abstract void checkEffective(StmtContext<QName, NotificationStatement, NotificationEffectiveStatement> var1);
}

