/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path;

import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PathEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.PathEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.PathExpressionParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.PathStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class PathStatementSupport
extends AbstractStatementSupport<PathExpression, PathStatement, PathEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.PATH).build();
    private static final PathStatementSupport LENIENT_INSTANCE = new PathStatementSupport(new PathExpressionParser.Lenient());
    private static final PathStatementSupport STRICT_INSTANCE = new PathStatementSupport(new PathExpressionParser());
    private final PathExpressionParser parser;

    private PathStatementSupport(PathExpressionParser parser) {
        super((StatementDefinition)YangStmtMapping.PATH);
        this.parser = Objects.requireNonNull(parser);
    }

    public static PathStatementSupport lenientInstance() {
        return LENIENT_INSTANCE;
    }

    public static PathStatementSupport strictInstance() {
        return STRICT_INSTANCE;
    }

    public PathExpression parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return this.parser.parseExpression(ctx, value);
    }

    public PathStatement createDeclared(StmtContext<PathExpression, PathStatement, ?> ctx) {
        return new PathStatementImpl(ctx);
    }

    public PathEffectiveStatement createEffective(StmtContext<PathExpression, PathStatement, PathEffectiveStatement> ctx) {
        return new PathEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

