/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.util.RegexUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.PatternConstraintImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.PatternEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.PatternStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPatternStatementSupport
extends AbstractStatementSupport<PatternConstraint, PatternStatement, PatternEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPatternStatementSupport.class);

    AbstractPatternStatementSupport() {
        super((StatementDefinition)YangStmtMapping.PATTERN, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public final PatternConstraint parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        String pattern = RegexUtils.getJavaRegexFromXSD((String)value);
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            LOG.debug("Pattern \"{}\" failed to compile at {}", new Object[]{pattern, ctx.getStatementSourceReference(), e});
            return null;
        }
        return new PatternConstraintImpl(pattern, value, Optional.empty(), Optional.empty());
    }

    public final PatternStatement createDeclared(StmtContext<PatternConstraint, PatternStatement, ?> ctx) {
        return new PatternStatementImpl(ctx);
    }

    public final PatternEffectiveStatement createEffective(StmtContext<PatternConstraint, PatternStatement, PatternEffectiveStatement> ctx) {
        return new PatternEffectiveStatementImpl(ctx);
    }
}

