/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;

final class PatternConstraintImpl
implements PatternConstraint,
Immutable {
    private final String regEx;
    private final String rawRegEx;
    private final String description;
    private final String reference;
    private final String errorAppTag;
    private final String errorMessage;
    private final ModifierKind modifier;

    PatternConstraintImpl(String regex, String rawRegex, Optional<String> description, Optional<String> reference) {
        this(regex, rawRegex, description.orElse(null), reference.orElse(null), null, null, null);
    }

    PatternConstraintImpl(String regex, String rawRegex, String description, String reference, String errorAppTag, String errorMessage, ModifierKind modifier) {
        this.regEx = Objects.requireNonNull(regex, "regex must not be null");
        this.rawRegEx = Objects.requireNonNull(rawRegex, "raw regex must not be null");
        this.description = description;
        this.reference = reference;
        this.errorAppTag = errorAppTag != null ? errorAppTag : "invalid-regular-expression";
        this.errorMessage = errorMessage;
        this.modifier = modifier;
    }

    public String getJavaPatternString() {
        return this.regEx;
    }

    public String getRegularExpressionString() {
        return this.rawRegEx;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getErrorAppTag() {
        return Optional.ofNullable(this.errorAppTag);
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Optional<ModifierKind> getModifier() {
        return Optional.ofNullable(this.modifier);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.errorAppTag, this.errorMessage, this.reference, this.regEx, this.modifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternConstraintImpl other = (PatternConstraintImpl)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.errorAppTag, other.errorAppTag) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.reference, other.reference) && Objects.equals(this.regEx, other.regEx) && Objects.equals(this.modifier, other.modifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("regex", (Object)this.regEx).add("description", (Object)this.description).add("reference", (Object)this.reference).add("errorAppTag", (Object)this.errorAppTag).add("errorMessage", (Object)this.errorMessage).add("modifier", (Object)this.modifier).toString();
    }
}

