/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date;

import java.time.format.DateTimeParseException;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.RevisionDateEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.RevisionDateStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RevisionDateStatementSupport
extends AbstractStatementSupport<Revision, RevisionDateStatement, RevisionDateEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REVISION_DATE).build();
    private static final RevisionDateStatementSupport INSTANCE = new RevisionDateStatementSupport();

    private RevisionDateStatementSupport() {
        super((StatementDefinition)YangStmtMapping.REVISION_DATE, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static RevisionDateStatementSupport getInstance() {
        return INSTANCE;
    }

    public Revision parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Revision.of((String)value);
        }
        catch (DateTimeParseException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Revision value %s is not in required format yyyy-MM-dd", new Object[]{value});
        }
    }

    public RevisionDateStatement createDeclared(StmtContext<Revision, RevisionDateStatement, ?> ctx) {
        return new RevisionDateStatementImpl(ctx);
    }

    public RevisionDateEffectiveStatement createEffective(StmtContext<Revision, RevisionDateStatement, RevisionDateEffectiveStatement> ctx) {
        return new RevisionDateEffectiveStatementImpl(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

