/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveModule;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class SubmoduleEffectiveStatementImpl
extends AbstractEffectiveModule<SubmoduleStatement, SubmoduleEffectiveStatement>
implements SubmoduleEffectiveStatement,
MutableStatement {
    private final ImmutableMap<String, ModuleEffectiveStatement> prefixToModule;
    private final ImmutableMap<QNameModule, String> namespaceToPrefix;
    private final QNameModule qnameModule;
    private Set<StmtContext<?, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>>> submoduleContexts;
    private ImmutableSet<Module> submodules;
    private boolean sealed;

    SubmoduleEffectiveStatementImpl(StmtContext<String, SubmoduleStatement, SubmoduleEffectiveStatement> ctx) {
        super(ctx, SubmoduleEffectiveStatementImpl.findSubmodulePrefix(ctx));
        String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf((Iterable)ctx.declaredSubstatements(), BelongsToStatement.class);
        QNameModule belongsToModuleQName = (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, (Object)belongsToModuleName);
        ImmutableMap.Builder prefixToModuleBuilder = ImmutableMap.builder();
        this.appendPrefixes(ctx, (ImmutableMap.Builder<String, ModuleEffectiveStatement>)prefixToModuleBuilder);
        this.prefixToModule = prefixToModuleBuilder.build();
        LinkedHashMap tmp = Maps.newLinkedHashMapWithExpectedSize((int)this.prefixToModule.size());
        for (Map.Entry e : this.prefixToModule.entrySet()) {
            tmp.putIfAbsent(((ModuleEffectiveStatement)e.getValue()).localQNameModule(), (String)e.getKey());
        }
        this.namespaceToPrefix = ImmutableMap.copyOf((Map)tmp);
        Optional submoduleRevision = this.findFirstEffectiveSubstatementArgument(RevisionEffectiveStatement.class);
        this.qnameModule = QNameModule.create((URI)belongsToModuleQName.getNamespace(), (Optional)submoduleRevision).intern();
        Map includedSubmodulesMap = ctx.getAllFromCurrentStmtCtxNamespace(IncludedSubmoduleNameToModuleCtx.class);
        if (includedSubmodulesMap != null) {
            HashSet<StmtContext> submoduleContextsInit = new HashSet<StmtContext>();
            for (StmtContext submoduleCtx : includedSubmodulesMap.values()) {
                submoduleContextsInit.add(submoduleCtx);
            }
            this.submoduleContexts = ImmutableSet.copyOf(submoduleContextsInit);
        } else {
            this.submoduleContexts = ImmutableSet.of();
        }
        if (!this.submoduleContexts.isEmpty()) {
            ((StmtContext.Mutable)ctx).addMutableStmtToSeal((MutableStatement)this);
            this.sealed = false;
        } else {
            this.submodules = ImmutableSet.of();
            this.sealed = true;
        }
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(@NonNull Class<N> namespace) {
        if (ModuleEffectiveStatement.PrefixToEffectiveModuleNamespace.class.equals(namespace)) {
            return Optional.of(this.prefixToModule);
        }
        if (ModuleEffectiveStatement.QNameModuleToPrefixNamespace.class.equals(namespace)) {
            return Optional.of(this.namespaceToPrefix);
        }
        return super.getNamespaceContents(namespace);
    }

    public Set<Module> getSubmodules() {
        Preconditions.checkState((boolean)this.sealed, (String)"Attempt to get base submodules from unsealed submodule effective statement %s", (Object)this.qnameModule);
        return this.submodules;
    }

    public void seal() {
        if (!this.sealed) {
            this.submodules = ImmutableSet.copyOf((Iterable)Iterables.transform(this.submoduleContexts, ctx -> (Module)ctx.buildEffective()));
            this.submoduleContexts = ImmutableSet.of();
            this.sealed = true;
        }
    }

    private static @NonNull String findSubmodulePrefix(StmtContext<String, ?, ?> ctx) {
        String name = (String)ctx.getStatementArgument();
        StmtContext belongsTo = (StmtContext)SourceException.throwIfNull((Object)StmtContextUtils.findFirstDeclaredSubstatement(ctx, BelongsToStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to find belongs-to statement in submodule %s.", (Object[])new Object[]{name});
        return SubmoduleEffectiveStatementImpl.findPrefix(belongsTo, "submodule", name);
    }
}

