/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class BitsSpecificationEffectiveStatement
extends DeclaredEffectiveStatementBase<String, TypeStatement.BitsSpecification>
implements TypeEffectiveStatement<TypeStatement.BitsSpecification> {
    private final @NonNull BitsTypeDefinition typeDefinition;

    BitsSpecificationEffectiveStatement(StmtContext<String, TypeStatement.BitsSpecification, EffectiveStatement<String, TypeStatement.BitsSpecification>> ctx) {
        super(ctx);
        BitsTypeBuilder builder = BaseTypes.bitsTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        Uint32 highestPosition = null;
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof BitEffectiveStatement) {
                Uint32 effectivePos;
                BitEffectiveStatement bitSubStmt = (BitEffectiveStatement)stmt;
                Optional declaredPosition = bitSubStmt.getDeclaredPosition();
                if (declaredPosition.isEmpty()) {
                    if (highestPosition != null) {
                        SourceException.throwIf((boolean)Uint32.MAX_VALUE.equals(highestPosition), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Bit %s must have a position statement", (Object[])new Object[]{bitSubStmt});
                        effectivePos = Uint32.fromIntBits((int)(highestPosition.intValue() + 1));
                    } else {
                        effectivePos = Uint32.ZERO;
                    }
                } else {
                    effectivePos = (Uint32)declaredPosition.get();
                }
                BitsTypeDefinition.Bit bit = EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos);
                if (highestPosition == null || highestPosition.compareTo(bit.getPosition()) < 0) {
                    highestPosition = bit.getPosition();
                }
                builder.addBit(bit);
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (BitsTypeDefinition)builder.build();
    }

    public BitsTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

