/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class BitsTypeEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private final @NonNull BitsTypeDefinition typeDefinition;

    BitsTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, BitsTypeDefinition baseType) {
        super(ctx);
        BitsTypeBuilder builder = RestrictedTypes.newBitsBuilder((BitsTypeDefinition)baseType, (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        YangVersion yangVersion = ctx.getRootVersion();
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof BitEffectiveStatement) {
                SourceException.throwIf((yangVersion != YangVersion.VERSION_1_1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Restricted bits type is allowed only in YANG 1.1 version.", (Object[])new Object[0]);
                BitEffectiveStatement bitSubStmt = (BitEffectiveStatement)stmt;
                Optional declared = bitSubStmt.getDeclaredPosition();
                Uint32 effectivePos = declared.isEmpty() ? BitsTypeEffectiveStatementImpl.getBaseTypeBitPosition((String)bitSubStmt.argument(), baseType, ctx) : (Uint32)declared.get();
                builder.addBit(EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos));
                continue;
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (BitsTypeDefinition)builder.build();
    }

    private static Uint32 getBaseTypeBitPosition(String bitName, BitsTypeDefinition baseType, StmtContext<?, ?, ?> ctx) {
        for (BitsTypeDefinition.Bit baseTypeBit : baseType.getBits()) {
            if (!bitName.equals(baseTypeBit.getName())) continue;
            return baseTypeBit.getPosition();
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Bit '%s' is not a subset of its base bits type %s.", new Object[]{bitName, baseType.getQName()});
    }

    public BitsTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

