/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeStatementImpl;

final class BuiltinTypeStatement
implements TypeStatement {
    private static final ImmutableMap<String, BuiltinTypeStatement> BUILTINS;
    private final String argument;

    private static void putBuiltin(ImmutableMap.Builder<String, BuiltinTypeStatement> builder, String argument) {
        builder.put((Object)argument, (Object)new BuiltinTypeStatement(argument));
    }

    private BuiltinTypeStatement(String argument) {
        this.argument = Objects.requireNonNull(argument);
    }

    static TypeStatement maybeReplace(TypeStatementImpl orig) {
        BuiltinTypeStatement builtin;
        if (orig.declaredSubstatements().isEmpty() && orig.getStatementSource() == StatementSource.DECLARATION && orig.statementDefinition() == YangStmtMapping.TYPE && (builtin = (BuiltinTypeStatement)BUILTINS.get(orig.argument())) != null) {
            return builtin;
        }
        return orig;
    }

    public String argument() {
        return this.argument;
    }

    public String rawArgument() {
        return this.argument;
    }

    public Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return ImmutableList.of();
    }

    public StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "binary");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "boolean");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "empty");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "instance-identifier");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int8");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int16");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int32");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int64");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "string");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint8");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint16");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint32");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint64");
        BUILTINS = builder.build();
    }
}

