/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class DecimalTypeEffectiveStatementImpl
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private final @NonNull DecimalTypeDefinition typeDefinition;

    DecimalTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, DecimalTypeDefinition baseType) {
        super(ctx);
        RangeRestrictedTypeBuilder builder = RestrictedTypes.newDecima64Builder((DecimalTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof RangeEffectiveStatement) {
                RangeEffectiveStatement range = (RangeEffectiveStatement)stmt;
                builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
            }
            if (stmt instanceof FractionDigitsEffectiveStatement) {
                Integer digits = (Integer)((FractionDigitsEffectiveStatement)stmt).argument();
                SourceException.throwIf((baseType.getFractionDigits() != digits.intValue() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Cannot override fraction-digits from base type %s to %s", (Object[])new Object[]{baseType, digits});
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        this.typeDefinition = (DecimalTypeDefinition)builder.build();
    }

    public DecimalTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

