/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.InvalidRangeConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.DeclaredEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class IntegralTypeEffectiveStatementImpl<T extends RangeRestrictedTypeDefinition<T, N>, N extends Number>
extends DeclaredEffectiveStatementBase<String, TypeStatement>
implements TypeEffectiveStatement<TypeStatement> {
    private final @NonNull T typeDefinition;

    IntegralTypeEffectiveStatementImpl(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, RangeRestrictedTypeBuilder<T, N> builder) {
        super(ctx);
        for (EffectiveStatement<?, ?> stmt : this.effectiveSubstatements()) {
            if (stmt instanceof RangeEffectiveStatement) {
                RangeEffectiveStatement rangeStmt = (RangeEffectiveStatement)stmt;
                builder.setRangeConstraint((ConstraintMetaDefinition)rangeStmt, (List)rangeStmt.argument());
            }
            if (!(stmt instanceof UnknownSchemaNode)) continue;
            builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
        }
        try {
            this.typeDefinition = (RangeRestrictedTypeDefinition)builder.build();
        }
        catch (InvalidRangeConstraintException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid range constraint: %s", new Object[]{e.getOffendingRanges()});
        }
    }

    public T getTypeDefinition() {
        return this.typeDefinition;
    }
}

