/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveDocumentedNodeWithStatus;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine.RefineEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class UsesEffectiveStatementImpl
extends AbstractEffectiveDocumentedNodeWithStatus<QName, UsesStatement>
implements UsesEffectiveStatement,
UsesNode {
    private final @NonNull GroupingDefinition sourceGrouping;
    private final boolean addedByUses;
    private final @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
    SchemaNodeIdentifier.Descendant, SchemaNode> refines;
    private final @NonNull ImmutableSet<AugmentationSchemaNode> augmentations;
    private final @Nullable RevisionAwareXPath whenCondition;

    UsesEffectiveStatementImpl(StmtContext<QName, UsesStatement, UsesEffectiveStatement> ctx) {
        super(ctx);
        StmtContext grpCtx = (StmtContext)ctx.getFromNamespace(GroupingNamespace.class, (Object)((QName)ctx.coerceStatementArgument()));
        this.sourceGrouping = (GroupingDefinition)grpCtx.buildEffective();
        this.addedByUses = ctx.getCopyHistory().contains(CopyType.ADDED_BY_USES);
        LinkedHashSet<AugmentationSchemaNode> augmentationsInit = new LinkedHashSet<AugmentationSchemaNode>();
        LinkedHashMap<SchemaNodeIdentifier.Descendant, SchemaNode> refinesInit = new LinkedHashMap<SchemaNodeIdentifier.Descendant, SchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : this.effectiveSubstatements()) {
            if (effectiveStatement instanceof AugmentationSchemaNode) {
                AugmentationSchemaNode augmentationSchema = (AugmentationSchemaNode)effectiveStatement;
                augmentationsInit.add(augmentationSchema);
            }
            if (!(effectiveStatement instanceof RefineEffectiveStatementImpl)) continue;
            RefineEffectiveStatementImpl refineStmt = (RefineEffectiveStatementImpl)effectiveStatement;
            refinesInit.put((SchemaNodeIdentifier.Descendant)refineStmt.argument(), refineStmt.getRefineTargetNode());
        }
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.refines = ImmutableMap.copyOf(refinesInit);
        this.whenCondition = this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class).orElse(null);
    }

    public GroupingDefinition getSourceGrouping() {
        return this.sourceGrouping;
    }

    public Collection<? extends AugmentationSchemaNode> getAugmentations() {
        return this.augmentations;
    }

    @Deprecated
    public boolean isAugmenting() {
        return false;
    }

    @Deprecated
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Map<SchemaNodeIdentifier.Descendant, SchemaNode> getRefines() {
        return this.refines;
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.ofNullable(this.whenCondition);
    }

    public String toString() {
        return UsesEffectiveStatementImpl.class.getSimpleName() + "[sourceGrouping=" + this.sourceGrouping.getQName() + "]";
    }
}

