/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.EmptyValueEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.EmptyValueStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.RegularValueEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.value.RegularValueStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class ValueStatementSupport
extends BaseInternedStatementSupport<Integer, ValueStatement, ValueEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.VALUE).build();
    private static final ValueStatementSupport INSTANCE = new ValueStatementSupport();

    private ValueStatementSupport() {
        super((StatementDefinition)YangStmtMapping.VALUE);
    }

    public static ValueStatementSupport getInstance() {
        return INSTANCE;
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "%s is not valid value statement integer argument in a range of -2147483648..2147483647", new Object[]{value});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected ValueStatement createDeclared(Integer argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularValueStatement(argument, substatements);
    }

    @Override
    protected ValueStatement createEmptyDeclared(@NonNull Integer argument) {
        return new EmptyValueStatement(argument);
    }

    @Override
    protected ValueEffectiveStatement createEmptyEffective(@NonNull ValueStatement declared) {
        return new EmptyValueEffectiveStatement(declared);
    }

    @Override
    protected ValueEffectiveStatement createEffective(StmtContext<Integer, ValueStatement, ValueEffectiveStatement> ctx, ValueStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularValueEffectiveStatement(declared, substatements);
    }
}

