/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.EmptyYangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.EmptyYangVersionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.RegularYangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.yang_version.RegularYangVersionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class YangVersionStatementSupport
extends BaseStatementSupport<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.YANG_VERSION).build();
    private static final YangVersionStatementSupport INSTANCE = new YangVersionStatementSupport();
    private static final @NonNull EmptyYangVersionStatement EMPTY_VER1_DECL = new EmptyYangVersionStatement(YangVersion.VERSION_1);
    private static final @NonNull EmptyYangVersionStatement EMPTY_VER1_1_DECL = new EmptyYangVersionStatement(YangVersion.VERSION_1_1);
    private static final @NonNull EmptyYangVersionEffectiveStatement EMPTY_VER1_EFF = new EmptyYangVersionEffectiveStatement(EMPTY_VER1_DECL);
    private static final @NonNull EmptyYangVersionEffectiveStatement EMPTY_VER1_1_EFF = new EmptyYangVersionEffectiveStatement(EMPTY_VER1_1_DECL);

    private YangVersionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.YANG_VERSION, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static YangVersionStatementSupport getInstance() {
        return INSTANCE;
    }

    public YangVersion parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (YangVersion)SourceException.unwrap((Optional)YangVersion.parse((String)value), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unsupported YANG version %s", (Object[])new Object[]{value});
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> stmt) {
        stmt.setRootVersion((YangVersion)stmt.getStatementArgument());
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected YangVersionStatement createDeclared(StmtContext<YangVersion, YangVersionStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularYangVersionStatement((YangVersion)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected YangVersionStatement createEmptyDeclared(StmtContext<YangVersion, YangVersionStatement, ?> ctx) {
        YangVersion argument = (YangVersion)ctx.coerceStatementArgument();
        switch (argument) {
            case VERSION_1: {
                return EMPTY_VER1_DECL;
            }
            case VERSION_1_1: {
                return EMPTY_VER1_1_DECL;
            }
        }
        throw new IllegalStateException("Unhandled version " + argument);
    }

    @Override
    protected YangVersionEffectiveStatement createEffective(StmtContext<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> ctx, YangVersionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularYangVersionEffectiveStatement(declared, substatements);
    }

    @Override
    protected YangVersionEffectiveStatement createEmptyEffective(StmtContext<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> ctx, YangVersionStatement declared) {
        if (EMPTY_VER1_DECL.equals(declared)) {
            return EMPTY_VER1_EFF;
        }
        if (EMPTY_VER1_1_DECL.equals(declared)) {
            return EMPTY_VER1_1_EFF;
        }
        return new EmptyYangVersionEffectiveStatement(declared);
    }
}

