/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.UintConversions;

@Beta
@NonNullByDefault
public class Uint32
extends Number
implements CanonicalValue<Uint32> {
    private static final CanonicalValueSupport<Uint32> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final long MAX_VALUE_LONG = 0xFFFFFFFFL;
    private static final String MAX_VALUE_STR = "4294967295";
    private static final String CACHE_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint32.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 256;
    private static final int CACHE_SIZE;
    private static final @NonNull Uint32[] CACHE;
    private static final Interner<Uint32> INTERNER;
    public static final Uint32 ZERO;
    public static final Uint32 ONE;
    public static final Uint32 TWO;
    public static final Uint32 TEN;
    public static final Uint32 MAX_VALUE;
    private final int value;

    private Uint32(int value) {
        this.value = value;
    }

    protected Uint32(Uint32 other) {
        this(other.value);
    }

    private static Uint32 instanceFor(int value) {
        long longSlot = Integer.toUnsignedLong(value);
        return longSlot < (long)CACHE.length ? CACHE[(int)longSlot] : new Uint32(value);
    }

    public static Uint32 fromIntBits(int bits) {
        return Uint32.instanceFor(bits);
    }

    public static Uint32 valueOf(byte byteVal) {
        UintConversions.checkNonNegative(byteVal, MAX_VALUE_STR);
        return Uint32.instanceFor(byteVal);
    }

    public static Uint32 valueOf(short shortVal) {
        UintConversions.checkNonNegative(shortVal, MAX_VALUE_STR);
        return Uint32.instanceFor(shortVal);
    }

    public static Uint32 valueOf(int intVal) {
        UintConversions.checkNonNegative(intVal, MAX_VALUE_STR);
        return Uint32.instanceFor(intVal);
    }

    public static Uint32 valueOf(long longVal) {
        UintConversions.checkRange(longVal, 0xFFFFFFFFL);
        return Uint32.instanceFor((int)longVal);
    }

    public static Uint32 valueOf(Uint8 uint) {
        return Uint32.instanceFor(uint.shortValue());
    }

    public static Uint32 valueOf(Uint16 uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(Uint64 uint) {
        return Uint32.valueOf(uint.longValue());
    }

    public static Uint32 valueOf(UnsignedInteger uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(String string) {
        return Uint32.valueOf(string, 10);
    }

    public static Uint32 valueOf(String string, int radix) {
        return Uint32.instanceFor(Integer.parseUnsignedInt(Objects.requireNonNull(string), radix));
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return Integer.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.longValue();
    }

    @Override
    public final double doubleValue() {
        return this.longValue();
    }

    @Override
    public final int compareTo(Uint32 o) {
        return Integer.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Integer.toUnsignedString(this.value);
    }

    @Override
    public final CanonicalValueSupport<Uint32> support() {
        return SUPPORT;
    }

    public final Uint32 intern() {
        return this.value >= 0 && this.value < CACHE_SIZE ? this : (Uint32)INTERNER.intern((Object)this);
    }

    public final long toJava() {
        return this.longValue();
    }

    public final UnsignedInteger toGuava() {
        return UnsignedInteger.fromIntBits((int)this.value);
    }

    public final Uint8 toUint8() {
        return Uint8.valueOf(this.toJava());
    }

    public final Uint16 toUint16() {
        return Uint16.valueOf(this.toJava());
    }

    public final Uint64 toUint64() {
        return Uint64.fromLongBits(this.longValue());
    }

    public final int hashCode() {
        return Integer.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint32 && this.value == ((Uint32)obj).value;
    }

    public final boolean equals(@Nullable Uint32 obj) {
        return this == obj || obj != null && this.value == obj.value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint32.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(CACHE_SIZE_PROPERTY, 256);
        CACHE_SIZE = p >= 0 ? Math.min(p, Integer.MAX_VALUE) : 256;
        Uint32[] c = new Uint32[CACHE_SIZE];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new Uint32(i);
        }
        CACHE = c;
        INTERNER = Interners.newWeakInterner();
        ZERO = Uint32.valueOf(0).intern();
        ONE = Uint32.valueOf(1).intern();
        TWO = Uint32.valueOf(2).intern();
        TEN = Uint32.valueOf(10).intern();
        MAX_VALUE = Uint32.valueOf(0xFFFFFFFFL).intern();
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint32> {
        public Support() {
            super(Uint32.class);
        }

        @Override
        public Variant<Uint32, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst((Object)Uint32.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

