/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.UintConversions;

@Beta
@NonNullByDefault
public class Uint64
extends Number
implements CanonicalValue<Uint64> {
    private static final CanonicalValueSupport<Uint64> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final String MAX_VALUE_STR = Long.toUnsignedString(-1L);
    private static final String CACHE_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint64.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 256;
    private static final long CACHE_SIZE;
    private static final @NonNull Uint64[] CACHE;
    private static final Interner<Uint64> INTERNER;
    public static final Uint64 ZERO;
    public static final Uint64 ONE;
    public static final Uint64 TWO;
    public static final Uint64 TEN;
    public static final Uint64 MAX_VALUE;
    private final long value;

    private Uint64(long value) {
        this.value = value;
    }

    protected Uint64(Uint64 other) {
        this(other.value);
    }

    private static Uint64 instanceFor(long value) {
        return value >= 0L && value < (long)CACHE.length ? CACHE[(int)value] : new Uint64(value);
    }

    public static Uint64 fromLongBits(long bits) {
        return Uint64.instanceFor(bits);
    }

    public static Uint64 valueOf(byte byteVal) {
        UintConversions.checkNonNegative(byteVal, MAX_VALUE_STR);
        return Uint64.instanceFor(byteVal);
    }

    public static Uint64 valueOf(short shortVal) {
        UintConversions.checkNonNegative(shortVal, MAX_VALUE_STR);
        return Uint64.instanceFor(shortVal);
    }

    public static Uint64 valueOf(int intVal) {
        UintConversions.checkNonNegative(intVal, MAX_VALUE_STR);
        return Uint64.instanceFor(intVal);
    }

    public static Uint64 valueOf(long longVal) {
        if (longVal >= 0L) {
            return Uint64.instanceFor(longVal);
        }
        throw new IllegalArgumentException("Invalid range: " + longVal + ", expected: [[0..18446744073709551615]].");
    }

    public static Uint64 valueOf(Uint8 uint) {
        return Uint64.instanceFor(uint.shortValue());
    }

    public static Uint64 valueOf(Uint16 uint) {
        return Uint64.instanceFor(uint.intValue());
    }

    public static Uint64 valueOf(Uint32 uint) {
        return Uint64.instanceFor(uint.longValue());
    }

    public static Uint64 valueOf(UnsignedLong ulong) {
        return Uint64.instanceFor(ulong.longValue());
    }

    public static Uint64 valueOf(BigInteger bigInt) {
        if (bigInt.signum() >= 0 && bigInt.bitLength() <= 64) {
            return Uint64.instanceFor(bigInt.longValue());
        }
        throw new IllegalArgumentException("Invalid range: " + bigInt + ", expected: [[0..18446744073709551615]].");
    }

    public static Uint64 valueOf(String string) {
        return Uint64.valueOf(string, 10);
    }

    public static Uint64 valueOf(String string, int radix) {
        return Uint64.instanceFor(Long.parseUnsignedLong(Objects.requireNonNull(string), radix));
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return UnsignedLong.fromLongBits((long)this.value).floatValue();
    }

    @Override
    public final double doubleValue() {
        return UnsignedLong.fromLongBits((long)this.value).doubleValue();
    }

    @Override
    public final int compareTo(Uint64 o) {
        return Long.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Long.toUnsignedString(this.value);
    }

    @Override
    public final CanonicalValueSupport<Uint64> support() {
        return SUPPORT;
    }

    public final Uint64 intern() {
        return this.value >= 0L && this.value < CACHE_SIZE ? this : (Uint64)INTERNER.intern((Object)this);
    }

    public final BigInteger toJava() {
        return this.toGuava().bigIntegerValue();
    }

    public final UnsignedLong toGuava() {
        return UnsignedLong.fromLongBits((long)this.value);
    }

    public final Uint8 toUint8() {
        if ((this.value & 0xFFFFFFFFFFFFFF00L) != 0L) {
            UintConversions.throwIAE(this.toString(), 255L);
        }
        return Uint8.fromByteBits((byte)this.value);
    }

    public final Uint16 toUint16() {
        if ((this.value & 0xFFFFFFFFFFFF0000L) != 0L) {
            UintConversions.throwIAE(this.toString(), 65535L);
        }
        return Uint16.fromShortBits((short)this.value);
    }

    public final Uint32 toUint32() {
        if ((this.value & 0xFFFFFFFF00000000L) != 0L) {
            UintConversions.throwIAE(this.toString(), 0xFFFFFFFFL);
        }
        return Uint32.fromIntBits((int)this.value);
    }

    public final int hashCode() {
        return Long.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint64 && this.value == ((Uint64)obj).value;
    }

    public final boolean equals(@Nullable Uint64 obj) {
        return this == obj || obj != null && this.value == obj.value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint64.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(CACHE_SIZE_PROPERTY, 256);
        CACHE_SIZE = p >= 0 ? (long)Math.min(p, Integer.MAX_VALUE) : 256L;
        Uint64[] c = new Uint64[(int)CACHE_SIZE];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new Uint64(i);
        }
        CACHE = c;
        INTERNER = Interners.newWeakInterner();
        ZERO = Uint64.valueOf(0).intern();
        ONE = Uint64.valueOf(1).intern();
        TWO = Uint64.valueOf(2).intern();
        TEN = Uint64.valueOf(10).intern();
        MAX_VALUE = Uint64.fromLongBits(-1L).intern();
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint64> {
        public Support() {
            super(Uint64.class);
        }

        @Override
        public Variant<Uint64, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst((Object)Uint64.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

