/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.util.TopologicalSort;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ModuleDependencySort {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleDependencySort.class);

    private ModuleDependencySort() {
    }

    public static List<Module> sort(Module ... modules) {
        return ModuleDependencySort.sort(Arrays.asList(modules));
    }

    public static List<Module> sort(Collection<? extends Module> modules) {
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(modules);
        return Lists.transform(sorted, input -> input == null ? null : ((ModuleNodeImpl)((Object)input)).getReference());
    }

    private static List<TopologicalSort.Node> sortInternal(Collection<? extends Module> modules) {
        Table<String, Optional<Revision>, ModuleNodeImpl> moduleGraph = ModuleDependencySort.createModuleGraph(modules);
        return TopologicalSort.sort(new HashSet(moduleGraph.values()));
    }

    private static Table<String, Optional<Revision>, ModuleNodeImpl> createModuleGraph(Collection<? extends Module> builders) {
        HashBasedTable moduleGraph = HashBasedTable.create();
        ModuleDependencySort.processModules((Table<String, Optional<Revision>, ModuleNodeImpl>)moduleGraph, builders);
        ModuleDependencySort.processDependencies((Table<String, Optional<Revision>, ModuleNodeImpl>)moduleGraph, builders);
        return moduleGraph;
    }

    private static void processDependencies(Table<String, Optional<Revision>, ModuleNodeImpl> moduleGraph, Collection<? extends Module> mmbs) {
        HashMap<URI, Module> allNS = new HashMap<URI, Module>();
        for (Module module : mmbs) {
            String name;
            HashMap<String, Optional> imported = new HashMap<String, Optional>();
            String fromName = module.getName();
            URI ns = module.getNamespace();
            Optional fromRevision = module.getRevision();
            Module prev = allNS.putIfAbsent(ns, module);
            if (prev != null && !fromName.equals(name = prev.getName())) {
                LOG.warn("Error while sorting module [{}, {}]: module with same namespace ({}) already loaded: [{}, {}]", new Object[]{fromName, fromRevision, ns, name, prev.getRevision()});
            }
            for (ModuleImport moduleImport : ModuleDependencySort.allImports(module)) {
                Optional impRevision;
                String toName = moduleImport.getModuleName();
                Optional toRevision = moduleImport.getRevision();
                ModuleNodeImpl from = (ModuleNodeImpl)((Object)moduleGraph.get((Object)fromName, (Object)fromRevision));
                ModuleNodeImpl to = ModuleDependencySort.getModuleByNameAndRevision(moduleGraph, fromName, fromRevision, toName, toRevision);
                if (module.getYangVersion() == YangVersion.VERSION_1 && (impRevision = (Optional)imported.get(toName)) != null && impRevision.isPresent() && !impRevision.equals(toRevision) && toRevision.isPresent()) {
                    throw new IllegalArgumentException(String.format("Module:%s imported twice with different revisions:%s, %s", toName, ModuleDependencySort.formatRevDate(impRevision), ModuleDependencySort.formatRevDate(toRevision)));
                }
                imported.put(toName, toRevision);
                from.addEdge((TopologicalSort.Node)to);
            }
        }
    }

    private static Collection<? extends ModuleImport> allImports(Module mod) {
        if (mod.getSubmodules().isEmpty()) {
            return mod.getImports();
        }
        LinkedHashSet concat = new LinkedHashSet();
        concat.addAll(mod.getImports());
        for (Module sub : mod.getSubmodules()) {
            concat.addAll(sub.getImports());
        }
        return concat;
    }

    private static ModuleNodeImpl getModuleByNameAndRevision(Table<String, Optional<Revision>, ModuleNodeImpl> moduleGraph, String fromName, Optional<Revision> fromRevision, String toName, Optional<Revision> toRevision) {
        Map modulerevs;
        ModuleNodeImpl exact = (ModuleNodeImpl)((Object)moduleGraph.get((Object)toName, toRevision));
        if (exact != null) {
            return exact;
        }
        if (toRevision.isEmpty() && !(modulerevs = moduleGraph.row((Object)toName)).isEmpty()) {
            ModuleNodeImpl first = (ModuleNodeImpl)((Object)modulerevs.values().iterator().next());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Import:{}:{} by module:{}:{} does not specify revision, using:{}:{} for module dependency sort", new Object[]{toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision), first.getName(), ModuleDependencySort.formatRevDate(first.getRevision())});
            }
            return first;
        }
        LOG.warn("Not existing module imported:{}:{} by:{}:{}", new Object[]{toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)});
        LOG.warn("Available models: {}", moduleGraph);
        throw new IllegalArgumentException(String.format("Not existing module imported:%s:%s by:%s:%s", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)));
    }

    private static void processModules(Table<String, Optional<Revision>, ModuleNodeImpl> moduleGraph, Iterable<? extends Module> modules) {
        for (Module module : modules) {
            String name = module.getName();
            Optional rev = module.getRevision();
            Map revs = moduleGraph.row((Object)name);
            if (revs.containsKey(rev)) {
                throw new IllegalArgumentException(String.format("Module:%s with revision:%s declared twice", name, ModuleDependencySort.formatRevDate(rev)));
            }
            revs.put(rev, new ModuleNodeImpl(name, rev.orElse(null), module));
        }
    }

    private static String formatRevDate(Optional<Revision> rev) {
        return rev.map(Revision::toString).orElse("default");
    }

    private static final class ModuleNodeImpl
    extends TopologicalSort.NodeImpl {
        private final String name;
        private final Revision revision;
        private final Module originalObject;

        ModuleNodeImpl(String name, Revision revision, Module module) {
            this.name = name;
            this.revision = revision;
            this.originalObject = module;
        }

        String getName() {
            return this.name;
        }

        Optional<Revision> getRevision() {
            return Optional.ofNullable(this.revision);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.revision);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ModuleNodeImpl other = (ModuleNodeImpl)((Object)obj);
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals((Object)other.revision));
        }

        public String toString() {
            return "Module [name=" + this.name + ", revision=" + ModuleDependencySort.formatRevDate(this.getRevision()) + "]";
        }

        public Module getReference() {
            return this.originalObject;
        }
    }
}

