/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaContextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaContextUtil.class);
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final Pattern STRIP_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");

    private SchemaContextUtil() {
    }

    public static SchemaNode findDataSchemaNode(SchemaContext context, SchemaPath schemaPath) {
        Iterable prefixedPath = schemaPath.getPathFromRoot();
        if (prefixedPath == null) {
            LOG.debug("Schema path {} has null path", (Object)schemaPath);
            return null;
        }
        LOG.trace("Looking for path {} in context {}", (Object)schemaPath, (Object)context);
        return SchemaContextUtil.findNodeInSchemaContext(context, prefixedPath);
    }

    @Beta
    public static SchemaNode findDataSchemaNode(SchemaContext context, List<QName> path) {
        return SchemaContextUtil.findTargetNode(context, null, (YangLocationPath)YangLocationPath.absolute((Collection)path.stream().map(arg_0 -> ((YangXPathAxis)YangXPathAxis.CHILD).asStep(arg_0)).collect(Collectors.toList())));
    }

    @Beta
    public static SchemaNode findDataSchemaNode(SchemaContext context, QName ... path) {
        return SchemaContextUtil.findDataSchemaNode(context, Arrays.asList(path));
    }

    @Deprecated
    public static SchemaNode findDataSchemaNode(SchemaContext context, Module module, PathExpression nonCondXPath) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(module, "module");
        String strXPath = nonCondXPath.getOriginalString();
        Preconditions.checkArgument((strXPath.indexOf(91) == -1 ? 1 : 0) != 0, (Object)"Revision Aware XPath may not contain a condition");
        if (nonCondXPath.isAbsolute()) {
            return SchemaContextUtil.findTargetNode(context, SchemaContextUtil.xpathToQNamePath(context, module, strXPath));
        }
        return null;
    }

    @Beta
    public static SchemaNode findDataTreeSchemaNode(SchemaContext ctx, QNameModule localModule, YangLocationPath absPath) {
        Preconditions.checkArgument((boolean)absPath.isAbsolute(), (String)"Unsupported relative path %s", (Object)absPath);
        return SchemaContextUtil.findTargetNode(ctx, localModule, absPath);
    }

    @Beta
    public static SchemaNode findDataTreeSchemaNode(SchemaContext ctx, QNameModule localModule, PathExpression absPath) {
        PathExpression.Steps pathSteps = absPath.getSteps();
        if (pathSteps instanceof PathExpression.LocationPathSteps) {
            return SchemaContextUtil.findDataTreeSchemaNode(ctx, localModule, ((PathExpression.LocationPathSteps)pathSteps).getLocationPath());
        }
        Preconditions.checkArgument((!(pathSteps instanceof PathExpression.DerefSteps) ? 1 : 0) != 0, (String)"No reference node for steps %s", (Object)pathSteps);
        throw new IllegalStateException("Unsupported path " + pathSteps);
    }

    public static SchemaNode findDataSchemaNodeForRelativeXPath(SchemaContext context, Module module, SchemaNode actualSchemaNode, PathExpression relativeXPath) {
        Preconditions.checkState((!relativeXPath.isAbsolute() ? 1 : 0) != 0, (Object)"Revision Aware XPath MUST be relative i.e. MUST contains ../, for non relative Revision Aware XPath use findDataSchemaNode method");
        return SchemaContextUtil.resolveRelativeXPath(context, module, relativeXPath.getOriginalString(), actualSchemaNode);
    }

    public static Module findParentModule(SchemaContext context, SchemaNode schemaNode) {
        QName qname = schemaNode.getPath().getLastComponent();
        Preconditions.checkState((qname != null ? 1 : 0) != 0, (Object)"Schema Path contains invalid state of path parts. The Schema Path MUST contain at least ONE QName  which defines namespace and Local name of path.");
        return context.findModule(qname.getModule()).orElse(null);
    }

    public static SchemaNode findNodeInSchemaContext(SchemaContext context, Iterable<QName> path) {
        QName current = path.iterator().next();
        LOG.trace("Looking up module {} in context {}", (Object)current, path);
        Optional module = context.findModule(current.getModule());
        if (module.isEmpty()) {
            LOG.debug("Module {} not found", (Object)current);
            return null;
        }
        return SchemaContextUtil.findNodeInModule((Module)module.get(), path);
    }

    @Beta
    public static @Nullable NotificationDefinition getNotificationSchema(@NonNull SchemaContext schema, @NonNull SchemaPath path) {
        Objects.requireNonNull(schema, "Schema context must not be null.");
        Objects.requireNonNull(path, "Schema path must not be null.");
        for (NotificationDefinition potential : schema.getNotifications()) {
            if (!path.equals((Object)potential.getPath())) continue;
            return potential;
        }
        return null;
    }

    @Beta
    public static @Nullable ContainerSchemaNode getRpcDataSchema(@NonNull SchemaContext schema, @NonNull SchemaPath path) {
        Objects.requireNonNull(schema, "Schema context must not be null.");
        Objects.requireNonNull(path, "Schema path must not be null.");
        Iterator it = path.getPathFromRoot().iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Rpc must have QName.");
        QName rpcName = (QName)it.next();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"input or output must be part of path.");
        QName inOrOut = (QName)it.next();
        for (RpcDefinition potential : schema.getOperations()) {
            if (!rpcName.equals((Object)potential.getQName())) continue;
            return SchemaNodeUtils.getRpcDataSchema(potential, inOrOut);
        }
        return null;
    }

    public static Set<SourceIdentifier> getConstituentModuleIdentifiers(SchemaContext context) {
        HashSet<SourceIdentifier> ret = new HashSet<SourceIdentifier>();
        for (Module module : context.getModules()) {
            ret.add(SchemaContextUtil.moduleToIdentifier(module));
            for (Module submodule : module.getSubmodules()) {
                ret.add(SchemaContextUtil.moduleToIdentifier(submodule));
            }
        }
        return ret;
    }

    private static SourceIdentifier moduleToIdentifier(Module module) {
        return RevisionSourceIdentifier.create((String)module.getName(), (Optional)module.getRevision());
    }

    private static SchemaNode findNodeInModule(Module module, Iterable<QName> path) {
        if (!path.iterator().hasNext()) {
            LOG.debug("No node matching {} found in node {}", path, (Object)module);
            return null;
        }
        QName current = path.iterator().next();
        LOG.trace("Looking for node {} in module {}", (Object)current, (Object)module);
        DataSchemaNode foundNode = null;
        Iterable<QName> nextPath = SchemaContextUtil.nextLevel(path);
        foundNode = module.getDataChildByName(current);
        if (foundNode != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName((DataNodeContainer)module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getRpcByName(module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getNotificationByName(module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null) {
            LOG.debug("No node matching {} found in node {}", path, (Object)module);
        }
        return foundNode;
    }

    private static SchemaNode findNodeIn(SchemaNode parent, Iterable<QName> path) {
        if (!path.iterator().hasNext()) {
            LOG.debug("No node matching {} found in node {}", path, (Object)parent);
            return null;
        }
        QName current = path.iterator().next();
        LOG.trace("Looking for node {} in node {}", (Object)current, (Object)parent);
        DataSchemaNode foundNode = null;
        Iterable<QName> nextPath = SchemaContextUtil.nextLevel(path);
        if (parent instanceof DataNodeContainer) {
            DataNodeContainer parentDataNodeContainer = (DataNodeContainer)parent;
            foundNode = parentDataNodeContainer.getDataChildByName(current);
            if (foundNode != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName(parentDataNodeContainer, current)) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
        }
        if (foundNode == null && parent instanceof ActionNodeContainer && (foundNode = (SchemaNode)((ActionNodeContainer)parent).getActions().stream().filter(act -> current.equals((Object)act.getQName())).findFirst().orElse(null)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && parent instanceof NotificationNodeContainer && (foundNode = (SchemaNode)((NotificationNodeContainer)parent).getNotifications().stream().filter(notif -> current.equals((Object)notif.getQName())).findFirst().orElse(null)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && parent instanceof OperationDefinition) {
            OperationDefinition parentRpcDefinition = (OperationDefinition)parent;
            if (current.getLocalName().equals("input") && (foundNode = parentRpcDefinition.getInput()) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (current.getLocalName().equals("output") && (foundNode = parentRpcDefinition.getOutput()) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName(parentRpcDefinition, current)) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
        }
        if (foundNode == null && parent instanceof ChoiceSchemaNode) {
            foundNode = ((ChoiceSchemaNode)parent).findCase(current).orElse(null);
            if (foundNode != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null) {
                for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)parent).getCases()) {
                    DataSchemaNode maybeChild = caseNode.getDataChildByName(current);
                    if (maybeChild == null) continue;
                    foundNode = SchemaContextUtil.findNodeIn((SchemaNode)maybeChild, nextPath);
                    break;
                }
            }
        }
        if (foundNode == null) {
            LOG.debug("No node matching {} found in node {}", path, (Object)parent);
        }
        return foundNode;
    }

    private static Iterable<QName> nextLevel(Iterable<QName> path) {
        return Iterables.skip(path, (int)1);
    }

    private static RpcDefinition getRpcByName(Module module, QName name) {
        for (RpcDefinition rpc : module.getRpcs()) {
            if (!rpc.getQName().equals((Object)name)) continue;
            return rpc;
        }
        return null;
    }

    private static NotificationDefinition getNotificationByName(Module module, QName name) {
        for (NotificationDefinition notification : module.getNotifications()) {
            if (!notification.getQName().equals((Object)name)) continue;
            return notification;
        }
        return null;
    }

    private static GroupingDefinition getGroupingByName(DataNodeContainer dataNodeContainer, QName name) {
        for (GroupingDefinition grouping : dataNodeContainer.getGroupings()) {
            if (!grouping.getQName().equals((Object)name)) continue;
            return grouping;
        }
        return null;
    }

    private static GroupingDefinition getGroupingByName(OperationDefinition rpc, QName name) {
        for (GroupingDefinition grouping : rpc.getGroupings()) {
            if (!grouping.getQName().equals((Object)name)) continue;
            return grouping;
        }
        return null;
    }

    private static List<QName> xpathToQNamePath(SchemaContext context, Module parentModule, String xpath) {
        ArrayList<QName> path = new ArrayList<QName>();
        for (String pathComponent : SLASH_SPLITTER.split((CharSequence)xpath)) {
            path.add(SchemaContextUtil.stringPathPartToQName(context, parentModule, pathComponent));
        }
        return path;
    }

    private static QName stringPathPartToQName(SchemaContext context, Module parentModule, String prefixedPathPart) {
        Objects.requireNonNull(context, "context");
        if (prefixedPathPart.indexOf(58) != -1) {
            Iterator prefixedName = COLON_SPLITTER.split((CharSequence)prefixedPathPart).iterator();
            String modulePrefix = (String)prefixedName.next();
            Module module = SchemaContextUtil.resolveModuleForPrefix(context, parentModule, modulePrefix);
            Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Failed to resolve xpath: no module found for prefix %s in module %s", (Object)modulePrefix, (Object)parentModule.getName());
            return QName.create((QNameModule)module.getQNameModule(), (String)((String)prefixedName.next()));
        }
        return QName.create((URI)parentModule.getNamespace(), (Optional)parentModule.getRevision(), (String)prefixedPathPart);
    }

    private static Module resolveModuleForPrefix(SchemaContext context, Module module, String prefix) {
        Objects.requireNonNull(context, "context");
        if (prefix.equals(module.getPrefix())) {
            return module;
        }
        for (ModuleImport mi : module.getImports()) {
            if (!prefix.equals(mi.getPrefix())) continue;
            return context.findModule(mi.getModuleName(), mi.getRevision()).orElse(null);
        }
        return null;
    }

    private static @Nullable SchemaNode resolveRelativeXPath(SchemaContext context, Module module, String pathStr, SchemaNode actualSchemaNode) {
        Preconditions.checkState((actualSchemaNode.getPath() != null ? 1 : 0) != 0, (Object)"Schema Path reference for Leafref cannot be NULL");
        return pathStr.startsWith("deref(") ? SchemaContextUtil.resolveDerefPath(context, module, actualSchemaNode, pathStr) : SchemaContextUtil.findTargetNode(context, SchemaContextUtil.resolveRelativePath(context, module, actualSchemaNode, SchemaContextUtil.doSplitXPath(pathStr)));
    }

    private static Iterable<QName> resolveRelativePath(SchemaContext context, Module module, SchemaNode actualSchemaNode, List<String> steps) {
        int colCount = SchemaContextUtil.normalizeXPath(steps);
        List<String> xpaths = colCount == 0 ? steps : steps.subList(colCount, steps.size());
        List<QName> walkablePath = SchemaContextUtil.createWalkablePath(actualSchemaNode.getPath().getPathFromRoot(), context, colCount);
        if (walkablePath.size() - colCount >= 0) {
            return Iterables.concat((Iterable)Iterables.limit(walkablePath, (int)(walkablePath.size() - colCount)), (Iterable)Iterables.transform(xpaths, input -> SchemaContextUtil.stringPathPartToQName(context, module, input)));
        }
        return Iterables.concat(walkablePath, (Iterable)Iterables.transform(xpaths, input -> SchemaContextUtil.stringPathPartToQName(context, module, input)));
    }

    private static List<QName> createWalkablePath(Iterable<QName> schemaNodePath, SchemaContext context, int colCount) {
        int i;
        ArrayList<Integer> indexToRemove = new ArrayList<Integer>();
        ArrayList schemaNodePathRet = Lists.newArrayList(schemaNodePath);
        int j = 0;
        for (i = schemaNodePathRet.size() - 1; i >= 0 && j != colCount; --i, ++j) {
            SchemaNode nodeIn = SchemaContextUtil.findTargetNode(context, schemaNodePathRet);
            if (nodeIn instanceof CaseSchemaNode || nodeIn instanceof ChoiceSchemaNode) {
                indexToRemove.add(i);
                --j;
            }
            schemaNodePathRet.remove(i);
        }
        schemaNodePathRet = Lists.newArrayList(schemaNodePath);
        Iterator iterator = indexToRemove.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            schemaNodePathRet.remove(i);
        }
        return schemaNodePathRet;
    }

    private static SchemaNode resolveDerefPath(SchemaContext context, Module module, SchemaNode actualSchemaNode, String xpath) {
        SchemaNode deref;
        int paren = xpath.indexOf(41, 6);
        Preconditions.checkArgument((paren != -1 ? 1 : 0) != 0, (String)"Cannot find matching parentheses in %s", (Object)xpath);
        String derefArg = xpath.substring(6, paren).strip();
        SchemaNode derefTarget = SchemaContextUtil.findTargetNode(context, SchemaContextUtil.resolveRelativePath(context, module, actualSchemaNode, SchemaContextUtil.doSplitXPath(derefArg)));
        Preconditions.checkArgument((derefTarget != null ? 1 : 0) != 0, (String)"Cannot find deref(%s) target node %s in context of %s", (Object)derefArg, (Object)actualSchemaNode);
        Preconditions.checkArgument((boolean)(derefTarget instanceof TypedDataSchemaNode), (String)"deref(%s) resolved to non-typed %s", (Object)derefArg, (Object)derefTarget);
        TypeDefinition targetType = ((TypedDataSchemaNode)derefTarget).getType();
        if (targetType instanceof InstanceIdentifierTypeDefinition) {
            throw new UnsupportedOperationException("Cannot infer instance-identifier reference " + targetType);
        }
        Preconditions.checkArgument((boolean)(targetType instanceof LeafrefTypeDefinition), (String)"Illegal target type %s", (Object)targetType);
        PathExpression targetPath = ((LeafrefTypeDefinition)targetType).getPathStatement();
        LOG.debug("Derefencing path {}", (Object)targetPath);
        SchemaNode schemaNode = deref = targetPath.isAbsolute() ? SchemaContextUtil.findTargetNode(context, actualSchemaNode.getQName().getModule(), ((PathExpression.LocationPathSteps)targetPath.getSteps()).getLocationPath()) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath(context, module, actualSchemaNode, targetPath);
        if (deref == null) {
            LOG.debug("Path {} could not be derefenced", (Object)targetPath);
            return null;
        }
        Preconditions.checkArgument((boolean)(deref instanceof LeafSchemaNode), (String)"Unexpected %s reference in %s", (Object)deref, (Object)targetPath);
        List<String> qnames = SchemaContextUtil.doSplitXPath(xpath.substring(paren + 1).stripLeading());
        return SchemaContextUtil.findTargetNode(context, SchemaContextUtil.resolveRelativePath(context, module, deref, qnames));
    }

    private static @Nullable SchemaNode findTargetNode(SchemaContext context, QNameModule localNamespace, YangLocationPath path) {
        ArrayDeque<QName> ret = new ArrayDeque<QName>();
        for (YangLocationPath.Step step : path.getSteps()) {
            if (step instanceof YangLocationPath.AxisStep) {
                YangXPathAxis axis = ((YangLocationPath.AxisStep)step).getAxis();
                Preconditions.checkState((axis == YangXPathAxis.PARENT ? 1 : 0) != 0, (String)"Unexpected axis %s", (Object)axis);
                ret.removeLast();
                continue;
            }
            Preconditions.checkState((boolean)(step instanceof YangLocationPath.QNameStep), (String)"Unhandled step %s in %s", (Object)step, (Object)path);
            ret.addLast(SchemaContextUtil.resolve(((YangLocationPath.QNameStep)step).getQName(), localNamespace));
        }
        return SchemaContextUtil.findTargetNode(context, ret);
    }

    private static @Nullable SchemaNode findTargetNode(SchemaContext context, Iterable<QName> qnamePath) {
        Optional pureData = context.findDataTreeChild(qnamePath);
        return pureData.isPresent() ? (SchemaNode)pureData.get() : SchemaContextUtil.findNodeInSchemaContext(context, qnamePath);
    }

    private static QName resolve(AbstractQName toResolve, QNameModule localNamespace) {
        if (toResolve instanceof QName) {
            return (QName)toResolve;
        }
        if (toResolve instanceof UnqualifiedQName) {
            return ((UnqualifiedQName)toResolve).bindTo(localNamespace);
        }
        throw new IllegalStateException("Unhandled step " + toResolve);
    }

    @VisibleForTesting
    static int normalizeXPath(List<String> xpath) {
        LOG.trace("Normalize {}", xpath);
        while (true) {
            int leadingParents = 0;
            while (true) {
                if (leadingParents == xpath.size()) {
                    return leadingParents;
                }
                if (!"..".equals(xpath.get(leadingParents))) break;
                ++leadingParents;
            }
            int dots = SchemaContextUtil.findDots(xpath, leadingParents + 1);
            if (dots == -1) {
                return leadingParents;
            }
            xpath.remove(dots - 1);
            xpath.remove(dots - 1);
            LOG.trace("Next iteration {}", xpath);
        }
    }

    private static int findDots(List<String> xpath, int startIndex) {
        for (int i = startIndex; i < xpath.size(); ++i) {
            if (!"..".equals(xpath.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> doSplitXPath(String xpath) {
        return SLASH_SPLITTER.splitToList((CharSequence)xpath);
    }

    public static TypeDefinition<?> getBaseTypeForLeafRef(LeafrefTypeDefinition typeDefinition, SchemaContext schemaContext, SchemaNode schema) {
        DataSchemaNode dataSchemaNode;
        PathExpression pathStatement = typeDefinition.getPathStatement();
        String pathStr = SchemaContextUtil.stripConditionsFromXPathString(pathStatement);
        if (pathStatement.isAbsolute()) {
            Optional basePotential;
            SchemaNode baseSchema = schema;
            while (baseSchema instanceof DerivableSchemaNode && (basePotential = ((DerivableSchemaNode)baseSchema).getOriginal()).isPresent()) {
                baseSchema = (SchemaNode)basePotential.get();
            }
            Module parentModule = SchemaContextUtil.findParentModuleOfReferencingType(schemaContext, baseSchema);
            dataSchemaNode = (DataSchemaNode)SchemaContextUtil.findTargetNode(schemaContext, SchemaContextUtil.xpathToQNamePath(schemaContext, parentModule, pathStr));
        } else {
            Module parentModule = SchemaContextUtil.findParentModule(schemaContext, schema);
            dataSchemaNode = (DataSchemaNode)SchemaContextUtil.resolveRelativeXPath(schemaContext, parentModule, pathStr, schema);
        }
        if (dataSchemaNode == null) {
            return null;
        }
        TypeDefinition<?> targetTypeDefinition = SchemaContextUtil.typeDefinition(dataSchemaNode);
        if (targetTypeDefinition instanceof LeafrefTypeDefinition) {
            return SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)targetTypeDefinition, schemaContext, (SchemaNode)dataSchemaNode);
        }
        return targetTypeDefinition;
    }

    public static TypeDefinition<?> getBaseTypeForLeafRef(LeafrefTypeDefinition typeDefinition, SchemaContext schemaContext, QName qname) {
        PathExpression pathStatement = typeDefinition.getPathStatement();
        if (!pathStatement.isAbsolute()) {
            return null;
        }
        Optional parentModule = schemaContext.findModule(qname.getModule());
        Preconditions.checkArgument((boolean)parentModule.isPresent(), (String)"Failed to find parent module for %s", (Object)qname);
        DataSchemaNode dataSchemaNode = (DataSchemaNode)SchemaContextUtil.findTargetNode(schemaContext, SchemaContextUtil.xpathToQNamePath(schemaContext, (Module)parentModule.get(), SchemaContextUtil.stripConditionsFromXPathString(pathStatement)));
        TypeDefinition<?> targetTypeDefinition = SchemaContextUtil.typeDefinition(dataSchemaNode);
        if (targetTypeDefinition instanceof LeafrefTypeDefinition) {
            return SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)targetTypeDefinition, schemaContext, (SchemaNode)dataSchemaNode);
        }
        return targetTypeDefinition;
    }

    private static Module findParentModuleOfReferencingType(SchemaContext schemaContext, SchemaNode schemaNode) {
        Preconditions.checkArgument((schemaContext != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL!");
        Preconditions.checkArgument((boolean)(schemaNode instanceof TypedDataSchemaNode), (String)"Unsupported node %s", (Object)schemaNode);
        TypeDefinition nodeType = ((TypedDataSchemaNode)schemaNode).getType();
        if (nodeType.getBaseType() != null) {
            while (nodeType.getBaseType() != null) {
                nodeType = nodeType.getBaseType();
            }
            return schemaContext.findModule(nodeType.getQName().getModule()).orElse(null);
        }
        return SchemaContextUtil.findParentModule(schemaContext, schemaNode);
    }

    @VisibleForTesting
    static String stripConditionsFromXPathString(PathExpression pathStatement) {
        return STRIP_PATTERN.matcher(pathStatement.getOriginalString()).replaceAll("");
    }

    private static TypeDefinition<?> typeDefinition(DataSchemaNode node) {
        Preconditions.checkArgument((boolean)(node instanceof TypedDataSchemaNode), (String)"Unhandled parameter type %s", (Object)node);
        TypeDefinition current = ((TypedDataSchemaNode)node).getType();
        TypeDefinition base = current.getBaseType();
        while (base != null) {
            current = base;
            base = current.getBaseType();
        }
        return current;
    }
}

